/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.zenscript;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import java.util.List;
import java.util.Map;
import leviathan143.loottweaker.common.darkmagic.CommonMethodHandles;
import leviathan143.loottweaker.common.lib.IDelayedTweak;
import leviathan143.loottweaker.common.lib.LootUtils;
import leviathan143.loottweaker.common.tweakers.LootTableTweaker;
import leviathan143.loottweaker.common.zenscript.ZenLootPoolWrapper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="loottweaker.vanilla.loot.LootTable")
public class ZenLootTableWrapper {
    private ResourceLocation name;
    private final LootTable backingTable;
    private final List<IDelayedTweak<LootTable, ZenLootTableWrapper>> delayedTweaks = Lists.newArrayList();
    private final Map<String, ZenLootPoolWrapper> wrapperCache = Maps.newHashMap();
    private boolean clear;

    public ZenLootTableWrapper(ResourceLocation name) {
        this.backingTable = new LootTable(LootUtils.NO_POOLS);
        this.name = name;
    }

    @ZenMethod
    public void clear() {
        this.clear = true;
    }

    @ZenMethod
    public ZenLootPoolWrapper addPool(String poolName, int minRolls, int maxRolls, int minBonusRolls, int maxBonusRolls) {
        LootPool pool = LootUtils.createPool(poolName, minRolls, maxRolls, minBonusRolls, maxBonusRolls);
        CraftTweakerAPI.apply((IAction)new AddPool(this, this.name, pool));
        ZenLootPoolWrapper wrapper = new ZenLootPoolWrapper(pool, this.name);
        this.wrapperCache.put(poolName, wrapper);
        return wrapper;
    }

    @ZenMethod
    public void removePool(String poolName) {
        CraftTweakerAPI.apply((IAction)new RemovePool(this, this.name, poolName));
    }

    @ZenMethod
    public ZenLootPoolWrapper getPool(String poolName) {
        LootPool pool = this.backingTable.getPool(poolName);
        if (pool == null) {
            pool = LootUtils.createTemporaryPool(poolName);
            this.backingTable.addPool(pool);
            if (!this.wrapperCache.containsKey(poolName)) {
                this.delayedTweaks.add(new TweakPool(poolName));
            }
        }
        if (!this.wrapperCache.containsKey(poolName)) {
            this.wrapperCache.put(poolName, new ZenLootPoolWrapper(pool, this.name));
        }
        return this.wrapperCache.get(poolName);
    }

    private ZenLootPoolWrapper getPoolInternal(String poolName) {
        LootPool pool = this.backingTable.getPool(poolName);
        if (pool == null) {
            pool = LootUtils.createTemporaryPool(poolName);
            this.backingTable.addPool(pool);
        }
        if (!this.wrapperCache.containsKey(poolName)) {
            this.wrapperCache.put(poolName, new ZenLootPoolWrapper(pool, this.name));
        }
        return this.wrapperCache.get(poolName);
    }

    public void applyLootTweaks(LootTable table) {
        if (this.clear) {
            CommonMethodHandles.getPoolsFromTable(table).clear();
            CraftTweakerAPI.logInfo((String)("Cleared entries of table " + this.name));
        }
        for (IDelayedTweak<LootTable, ZenLootTableWrapper> tweak : this.delayedTweaks) {
            tweak.applyTweak(table, this);
        }
        CraftTweakerAPI.logInfo((String)("Applied tweaks to table " + this.name));
    }

    private static class RemovePool
    implements IAction,
    IDelayedTweak<LootTable, ZenLootTableWrapper> {
        private ZenLootTableWrapper wrapper;
        private ResourceLocation tableName;
        private String poolName;

        public RemovePool(ZenLootTableWrapper wrapper, ResourceLocation tableName, String poolName) {
            this.wrapper = wrapper;
            this.tableName = tableName;
            this.poolName = poolName;
        }

        public void apply() {
            this.wrapper.delayedTweaks.add(this);
        }

        @Override
        public void applyTweak(LootTable table, ZenLootTableWrapper wrapper) {
            if (table.getPool(this.poolName) == null) {
                CraftTweakerAPI.logError((String)String.format("No loot pool with name %s exists in table %s!", this.poolName, wrapper.name));
                return;
            }
            table.removePool(this.poolName);
        }

        public String describe() {
            return String.format("Queuing pool %s for removal from table %s", this.poolName, this.tableName);
        }
    }

    private static class AddPool
    implements IAction,
    IDelayedTweak<LootTable, ZenLootTableWrapper> {
        private ZenLootTableWrapper wrapper;
        private ResourceLocation tableName;
        private LootPool pool;

        public AddPool(ZenLootTableWrapper wrapper, ResourceLocation name, LootPool pool) {
            this.wrapper = wrapper;
            this.tableName = name;
            this.pool = pool;
        }

        public void apply() {
            this.wrapper.delayedTweaks.add(this);
        }

        @Override
        public void applyTweak(LootTable table, ZenLootTableWrapper wrapper) {
            table.addPool(this.pool);
            wrapper.getPoolInternal(this.pool.getName()).applyLootTweaks(this.pool);
        }

        public String describe() {
            return String.format("Queuing pool %s for addition to table %s", this.pool.getName(), this.tableName);
        }
    }

    private static class TweakPool
    implements IDelayedTweak<LootTable, ZenLootTableWrapper> {
        private String poolName;

        public TweakPool(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public void applyTweak(LootTable table, ZenLootTableWrapper wrapper) {
            LootPool pool = table.getPool(this.poolName);
            if (pool == null) {
                CraftTweakerAPI.logError((String)String.format("No loot pool with name %s exists in table %s!", this.poolName, wrapper.name));
                return;
            }
            if (pool.isFrozen()) {
                LootTableTweaker.LOGGER.debug("Skipped modifying pool {} of table {} because it is frozen", (Object)this.poolName, (Object)wrapper.name);
                return;
            }
            wrapper.getPoolInternal(this.poolName).applyLootTweaks(pool);
        }
    }
}

