/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.arithmetics;

import moze_intel.projecte.emc.arithmetics.FullBigFractionArithmetic;
import moze_intel.projecte.shaded.org.apache.commons.math3.fraction.BigFraction;

public class HiddenBigFractionArithmetic
extends FullBigFractionArithmetic {
    @Override
    public BigFraction div(BigFraction a, long b) {
        try {
            if (this.isFree(a)) {
                return this.getFree();
            }
            if (a.getDenominatorAsLong() <= 0L) {
                return BigFraction.ZERO;
            }
            BigFraction result = a.divide(b);
            if (BigFraction.ZERO.compareTo(result) <= 0 && result.compareTo(BigFraction.ONE) < 0) {
                return result;
            }
            return new BigFraction(result.longValue());
        }
        catch (ArithmeticException e) {
            return BigFraction.ZERO;
        }
    }
}

