/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IItemCharge;
import moze_intel.projecte.gameObjs.items.CataliticLens;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class DestructionCatalyst
extends ItemPE
implements IItemCharge {
    public DestructionCatalyst() {
        this.func_77655_b("destruction_catalyst");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos coords, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        int numRows = this.calculateDepthFromCharge(stack);
        boolean hasAction = false;
        AxisAlignedBB box = WorldHelper.getDeepBox(coords, facing, --numRows);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(pos);
            float hardness = state.func_185887_b(world, pos);
            if (world.func_175623_d(pos) || hardness >= 50.0f || hardness == -1.0f) continue;
            if (!DestructionCatalyst.consumeFuel(player, stack, 8.0, true)) break;
            hasAction = true;
            if (!PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) continue;
            List<ItemStack> list = WorldHelper.getBlockDrops(world, player, state, stack, pos);
            if (list != null && list.size() > 0 && !(state.func_177230_c() instanceof BlockShulkerBox)) {
                drops.addAll(list);
            }
            world.func_175698_g(pos);
            if (world.field_73012_v.nextInt(8) != 0) continue;
            ((WorldServer)world).func_175739_a(world.field_73012_v.nextBoolean() ? EnumParticleTypes.EXPLOSION_NORMAL : EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2, 0.0, 0.0, 0.0, 0.05, new int[0]);
        }
        PlayerHelper.swingItem(player, hand);
        if (hasAction) {
            WorldHelper.createLootDrop(drops, world, coords);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.DESTRUCT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    private int calculateDepthFromCharge(ItemStack stack) {
        int charge = this.getCharge(stack);
        if (charge <= 0) {
            return 1;
        }
        if (this instanceof CataliticLens) {
            return 8 + charge * 8;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 3;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getNumCharges(stack);
    }
}

