/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost;

import com.timwoodcreates.roost.Roost;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="roost")
public class RoostConfig {
    @Config.Comment(value={"The speed multiplier for the roost. Higher is faster."})
    @Config.LangKey(value="config.roost.roostSpeed")
    @Config.RangeDouble(min=0.01, max=100.0)
    public static double roostSpeed = 1.0;
    @Config.Comment(value={"The speed multiplier for the breeder. Higher is faster."})
    @Config.LangKey(value="config.roost.breederSpeed")
    @Config.RangeDouble(min=0.01, max=100.0)
    public static double breederSpeed = 1.0;
    @Config.Comment(value={"Prevent vanilla chickens from laying eggs. Of interest to modpack makers only."})
    public static boolean disableEggLaying = false;

    public static void sync() {
        ConfigManager.sync((String)"roost", (Config.Type)Config.Type.INSTANCE);
    }

    @Mod.EventBusSubscriber(modid="roost")
    public static class SyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("roost")) {
                RoostConfig.sync();
                Roost.LOGGER.info("Configuration has been saved.");
            }
        }
    }
}

