/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.integration.jei;

import com.timwoodcreates.roost.RoostBlocks;
import com.timwoodcreates.roost.RoostItems;
import com.timwoodcreates.roost.data.DataChicken;
import com.timwoodcreates.roost.integration.jei.breeding.BreedingRecipe;
import com.timwoodcreates.roost.integration.jei.breeding.BreedingRecipeCategory;
import com.timwoodcreates.roost.integration.jei.catching.CatchingRecipe;
import com.timwoodcreates.roost.integration.jei.catching.CatchingRecipeCategory;
import com.timwoodcreates.roost.integration.jei.roosting.RoostingRecipe;
import com.timwoodcreates.roost.integration.jei.roosting.RoostingRecipeCategory;
import java.util.LinkedList;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@JEIPlugin
public class RoostJEIPlugin
extends BlankModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.registerSubtypeInterpreter((Item)RoostItems.ITEM_CHICKEN, (ISubtypeRegistry.ISubtypeInterpreter)new ItemChickenSubtypeInterpreter());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new BreedingRecipeCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CatchingRecipeCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new RoostingRecipeCategory(jeiHelpers.getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        LinkedList<BreedingRecipe> breedingRecipies = new LinkedList<BreedingRecipe>();
        LinkedList<CatchingRecipe> catchingRecipies = new LinkedList<CatchingRecipe>();
        LinkedList<RoostingRecipe> roostingRecipies = new LinkedList<RoostingRecipe>();
        for (DataChicken chicken : DataChicken.getAllChickens()) {
            if (chicken.hasParents()) {
                breedingRecipies.add(new BreedingRecipe(chicken));
            }
            roostingRecipies.add(new RoostingRecipe(chicken));
            catchingRecipies.add(new CatchingRecipe(chicken));
        }
        registry.addRecipes(breedingRecipies, "roost.breeding");
        registry.addRecipes(catchingRecipies, "roost.catching");
        registry.addRecipes(roostingRecipies, "roost.roosting");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)RoostBlocks.BLOCK_BREEDER), new String[]{"roost.breeding"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)RoostItems.ITEM_CATCHER), new String[]{"roost.catching"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)RoostBlocks.BLOCK_ROOST), new String[]{"roost.roosting"});
    }

    private class ItemChickenSubtypeInterpreter
    implements ISubtypeRegistry.ISubtypeInterpreter {
        private ItemChickenSubtypeInterpreter() {
        }

        public String apply(ItemStack itemStack) {
            NBTTagCompound tagCompound = itemStack.func_77978_p();
            if (tagCompound == null) {
                return null;
            }
            return tagCompound.func_74779_i("Chicken");
        }
    }
}

