/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.render;

import com.google.common.collect.ImmutableList;
import com.timwoodcreates.roost.RoostTextures;
import com.timwoodcreates.roost.data.DataChicken;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ModelItemChicken
implements IModel {
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        return new BakedModelItemChicken(state, format, bakedTextureGetter);
    }

    public static Collection<ResourceLocation> getItemTextures() {
        List<ResourceLocation> textures = DataChicken.getAllChickens().stream().map(DataChicken::getTextureName).filter(Objects::nonNull).map(ModelItemChicken::getTextureLocation).collect(Collectors.toList());
        textures.add(ModelItemChicken.getTextureLocation("vanilla"));
        RoostTextures.stockTextures.stream().map(ModelItemChicken::getTextureLocation).forEach(textures::add);
        return textures;
    }

    private static ResourceLocation getTextureLocation(String tex) {
        return new ResourceLocation("roost", "items/chicken/" + tex);
    }

    @SubscribeEvent
    public static void preStitch(TextureStitchEvent.Pre event) {
        for (ResourceLocation itemTexture : ModelItemChicken.getItemTextures()) {
            event.getMap().func_174942_a(itemTexture);
        }
    }

    public static class ModelItemChickenLoader
    implements ICustomModelLoader {
        public static ModelItemChickenLoader INSTANCE = new ModelItemChickenLoader();

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("roost") && modelLocation.func_110623_a().equals("models/item/chicken");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return new ModelItemChicken();
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }

    public static class BakedModelItemChicken
    implements IBakedModel {
        public Map<String, IBakedModel> models = new HashMap<String, IBakedModel>();
        public ChickenItemOverrideList overrides = new ChickenItemOverrideList();
        public IModel chickenModel;
        public IBakedModel missingChickenBakedModel;
        VertexFormat format;
        IModelState state;
        public final ResourceLocation placeholder = new ResourceLocation("roost", "items/chicken/vanilla");

        public BakedModelItemChicken(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            this.state = state;
            this.format = format;
            this.chickenModel = ModelLoaderRegistry.getModelOrMissing((ResourceLocation)new ResourceLocation("roost:item/chicken/vanilla"));
            IBakedModel baked = this.chickenModel.bake(state, format, bakedTextureGetter);
            this.models.put("minecraft:vanilla", baked);
            this.missingChickenBakedModel = this.chickenModel.bake(state, format, loc -> (TextureAtlasSprite)bakedTextureGetter.apply(TextureMap.field_174945_f));
        }

        public IBakedModel bakeChicken(String chickenName) {
            DataChicken chickenData = DataChicken.getDataFromName(chickenName);
            ResourceLocation texLoc = ModelItemChicken.getTextureLocation(chickenData.getTextureName());
            Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            return this.chickenModel.bake(this.state, this.format, loc -> (TextureAtlasSprite)textureGetter.apply(loc.equals((Object)this.placeholder) ? texLoc : loc));
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public class ChickenItemOverrideList
        extends ItemOverrideList {
            public ChickenItemOverrideList() {
                super((List)ImmutableList.of());
            }

            public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                String name;
                IBakedModel model;
                DataChicken chickenData = DataChicken.getDataFromStack(stack);
                if (chickenData != null && (model = BakedModelItemChicken.this.models.computeIfAbsent(name = chickenData.getChickenType(), BakedModelItemChicken.this::bakeChicken)) != null) {
                    return model;
                }
                return BakedModelItemChicken.this.missingChickenBakedModel;
            }
        }
    }
}

