/*
 * Decompiled with CFR 0.152.
 */
package com.timwoodcreates.roost.tileentity;

import com.timwoodcreates.roost.tileentity.TileEntityRoost;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEntityCollector
extends TileEntity
implements ISidedInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private int searchOffset = 0;
    private IItemHandler itemHandler;

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.updateSearchOffset();
            this.gatherItems();
        }
    }

    private void updateSearchOffset() {
        this.searchOffset = (this.searchOffset + 1) % 27;
    }

    private void gatherItems() {
        for (int x = -4; x < 5; ++x) {
            int y = this.searchOffset / 9;
            int z = this.searchOffset % 9 - 4;
            this.gatherItemAtPos(this.field_174879_c.func_177982_a(x, y, z));
        }
    }

    private void gatherItemAtPos(BlockPos pos) {
        int[] slots;
        TileEntity tileEntity = this.func_145831_w().func_175625_s(pos);
        if (!(tileEntity instanceof TileEntityRoost)) {
            return;
        }
        TileEntityRoost tileEntityRoost = (TileEntityRoost)this.func_145831_w().func_175625_s(pos);
        for (int i : slots = tileEntityRoost.func_180463_a(null)) {
            if (!this.pullItemFromSlot(tileEntityRoost, i)) continue;
            return;
        }
    }

    private boolean pullItemFromSlot(TileEntityRoost tileRoost, int index) {
        ItemStack itemStack = tileRoost.func_70301_a(index);
        if (!itemStack.func_190926_b() && tileRoost.func_180461_b(index, itemStack, null)) {
            ItemStack itemStack1 = itemStack.func_77946_l();
            ItemStack itemStack2 = TileEntityHopper.func_174918_a((IInventory)tileRoost, (IInventory)this, (ItemStack)tileRoost.func_70298_a(index, 1), null);
            if (itemStack2.func_190926_b()) {
                tileRoost.func_70296_d();
                this.func_70296_d();
                return true;
            }
            tileRoost.func_70299_a(index, itemStack1);
        }
        return false;
    }

    public String func_70005_c_() {
        return "container.roost.collector";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return 27;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return true;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] itemSlots = new int[27];
        for (int i = 0; i < 27; ++i) {
            itemSlots[i] = i;
        }
        return itemSlots;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        return compound;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandler == null) {
                this.itemHandler = new InvWrapper((IInventory)this);
            }
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

