/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.endergy.capacitor;

import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.EnderIO;
import javax.annotation.Nonnull;

public enum EndergyCapacitorData implements ICapacitorData
{
    GRAINY_CAPACITOR("grains", 1.0f),
    CRYSTALLINE_CAPACITOR("crystalline", 3.5f),
    MELODIC_CAPACITOR("melodic", 4.0f),
    STELLAR_CAPACITOR("stellar", 5.0f),
    TOTEMIC_CAPACITOR("totemic", 3.5f),
    SILVER_CAPACITOR("silver", 1.0f),
    ENERGETIC_SILVER_CAPACITOR("energetic_silver", 2.0f),
    VIVID_CAPACITOR("vivid", 3.0f);

    @Nonnull
    public static final ICapacitorData NONE;
    @Nonnull
    private final String unlocalizedName;
    private final float baselevel;
    private final boolean regular;

    private EndergyCapacitorData(String unlocalizedName) {
        this(unlocalizedName, 1.0f, false);
    }

    private EndergyCapacitorData(String unlocalizedName, float baselevel) {
        this(unlocalizedName, baselevel, true);
    }

    private EndergyCapacitorData(String unlocalizedName, float baselevel, boolean regular) {
        this.unlocalizedName = unlocalizedName;
        this.baselevel = baselevel;
        this.regular = regular;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Nonnull
    public String getLocalizedName() {
        return EnderIO.lang.localize(this.getUnlocalizedName() + ".name");
    }

    public float getUnscaledValue(@Nonnull ICapacitorKey key) {
        return this.baselevel;
    }

    public boolean isRegular() {
        return this.regular;
    }

    static {
        NONE = new ICapacitorData(){

            public float getUnscaledValue(@Nonnull ICapacitorKey key) {
                return 0.0f;
            }

            @Nonnull
            public String getUnlocalizedName() {
                return "none";
            }

            @Nonnull
            public String getLocalizedName() {
                return "none";
            }

            public int hashCode() {
                return 42;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
    }
}

