/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.morechickens.handlers;

import com.gendeathrow.morechickens.util.ChickenInformation;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.item.ItemSpawnEgg;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EggTooltips {
    @SubscribeEvent
    public void renderToolTip(ItemTooltipEvent event) {
        if (event.getEntity() == null || event.getEntity().field_70170_p == null || !event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getItemStack().func_77973_b() instanceof ItemSpawnEgg) {
            ChickensRegistryItem chicken = ChickensRegistry.getByRegistryName((String)ItemSpawnEgg.getTypeFromStack((ItemStack)event.getItemStack()));
            if (chicken == null) {
                return;
            }
            ItemStack layitem = chicken.createLayItem();
            if (layitem != null && layitem.func_77973_b() != null) {
                this.addLine(event, new TextComponentTranslation("text.morechickens.layitem", new Object[]{layitem.func_82833_r()}).func_150254_d());
            } else {
                this.addLine(event, new TextComponentTranslation("text.morechickens.nolayitem", new Object[]{layitem.func_82833_r()}).func_150254_d());
            }
            if (chicken.getSpawnType() != SpawnType.NONE) {
                TextFormatting format = chicken.getSpawnType() == SpawnType.NORMAL ? TextFormatting.GREEN : (chicken.getSpawnType() == SpawnType.HELL ? TextFormatting.RED : (chicken.getSpawnType() == SpawnType.SNOW ? TextFormatting.AQUA : TextFormatting.WHITE));
                this.addLine(event, TextFormatting.AQUA + new TextComponentTranslation("text.morechickens.spawnType", new Object[0]).func_150254_d() + ": " + TextFormatting.RESET + format + chicken.getSpawnType().toString());
            }
            if (!chicken.isBreedable()) {
                this.addLine(event, TextFormatting.RED + new TextComponentTranslation("text.morechickens.notbreedable", new Object[0]).func_150254_d());
            } else {
                String parent1 = new TextComponentTranslation("entity." + chicken.getParent1().getEntityName() + ".name", new Object[0]).func_150254_d();
                String parent2 = new TextComponentTranslation("entity." + chicken.getParent2().getEntityName() + ".name", new Object[0]).func_150254_d();
                this.addLine(event, TextFormatting.YELLOW + new TextComponentTranslation("text.morechickens.breedable", new Object[0]).func_150254_d() + ": " + TextFormatting.RESET + TextFormatting.ITALIC + TextFormatting.GOLD + parent1 + TextFormatting.RESET + " & " + TextFormatting.ITALIC + TextFormatting.GOLD + parent2);
            }
            if (ChickenInformation.TOOLTIPCHICKENS.containsKey(ItemSpawnEgg.getTypeFromStack((ItemStack)event.getItemStack()))) {
                ChickenInformation info = ChickenInformation.TOOLTIPCHICKENS.get(ItemSpawnEgg.getTypeFromStack((ItemStack)event.getItemStack()));
                event.getToolTip().addAll(info.getToolTip());
            }
        }
    }

    private void addLine(ItemTooltipEvent event, String line) {
        event.getToolTip().add(line);
    }
}

