/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends GuiScreen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private GuiTextField nameTextField;
    private String nameText;
    private GuiTextField xTextField;
    private GuiTextField yTextField;
    private GuiTextField zTextField;
    private GuiTextField yawTextField;
    private GuiTextField charTextField;
    private String initial;
    private String yaw;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private int color;
    private Waypoint point;
    private boolean dropped;
    private boolean waypointDisabled;
    private MySuperTinyButton disableButton;
    private NumericFieldValidator fieldValidator;

    public GuiAddWaypoint(IXaeroMinimap modMain, GuiScreen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this.parentGuiScreen = par1GuiScreen;
        this.point = point;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.fromSet = defaultWorld.getCurrent();
        this.defaultWorld = defaultWorld;
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, defaultParentContainer);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(defaultParentContainer), this.waypointsManager, defaultWorld.getFullId());
        this.sets = new GuiWaypointSets(false, defaultWorld);
        this.nameText = "";
        this.dropDowns = new ArrayList();
        this.initial = "";
        this.yaw = "";
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.color = point == null ? (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1)) : point.getColor();
    }

    public String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public int[] createValues() {
        int[] values = new int[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = i;
        }
        return values;
    }

    public void func_73866_w_() {
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.field_146292_n.add(new MySuperTinyButton(203, this.field_146294_l / 2 - 165, 121, I18n.func_135052_a((String)"* 8", (Object[])new Object[0])));
        this.field_146292_n.add(new MySuperTinyButton(204, this.field_146294_l / 2 - 165, 147, I18n.func_135052_a((String)"/ 8", (Object[])new Object[0])));
        this.nameTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 104, 200, 20);
        this.xTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 109, 134, 50, 20);
        this.yTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 53, 134, 50, 20);
        this.zTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 3, 134, 50, 20);
        this.yawTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 59, 134, 50, 20);
        this.charTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 25, 164, 50, 20);
        if (this.point == null) {
            this.screenTitle = I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]);
            this.nameTextField.func_146180_a(this.nameText);
            boolean divideBy8 = this.waypointsManager.divideBy8(this.worlds.getCurrentKeys()[0]);
            this.xTextField.func_146180_a("" + OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70165_t) * (divideBy8 ? 8 : 1));
            this.yTextField.func_146180_a("" + OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70163_u));
            this.zTextField.func_146180_a("" + OptimizedMath.myFloor(this.field_146297_k.field_71439_g.field_70161_v) * (divideBy8 ? 8 : 1));
            this.yawTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            this.charTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
        } else {
            this.screenTitle = I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
            this.nameTextField.func_146180_a(this.point.getLocalizedName());
            this.xTextField.func_146180_a("" + this.point.getX());
            this.yTextField.func_146180_a("" + this.point.getY());
            this.zTextField.func_146180_a("" + this.point.getZ());
            this.initial = this.point.getSymbol();
            if (this.point.isRotation()) {
                this.yaw = "" + this.point.getYaw();
            }
            this.yawTextField.func_146180_a(this.yaw);
            this.charTextField.func_146180_a(this.initial);
            this.color = this.point.getColor();
            this.waypointDisabled = this.point.isDisabled();
        }
        String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(205, this.field_146294_l / 2 + 31, 164, enabledisable[this.waypointDisabled ? 1 : 0]);
        this.field_146292_n.add(this.disableButton);
        this.dropDowns.clear();
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.field_146294_l / 2 - 60, 82, 120, this.color, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.field_146294_l / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.nameTextField.func_146195_b(true);
        Keyboard.enableRepeatEvents((boolean)true);
        this.updateConfirmButton();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        if (this.nameTextField.func_146206_l()) {
            if (par2 == 15) {
                this.nameTextField.func_146195_b(false);
                this.xTextField.func_146195_b(true);
            }
            this.nameTextField.func_146201_a(par1, par2);
            if (this.initial.length() == 0 && this.nameTextField.func_146179_b().length() > 0) {
                this.initial = this.nameTextField.func_146179_b().substring(0, 1);
            }
        } else if (this.xTextField.func_146206_l()) {
            if (par2 == 15) {
                this.xTextField.func_146195_b(false);
                this.yTextField.func_146195_b(true);
            }
            this.xTextField.func_146201_a(par1, par2);
        } else if (this.yTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yTextField.func_146195_b(false);
                this.zTextField.func_146195_b(true);
            }
            this.yTextField.func_146201_a(par1, par2);
        } else if (this.zTextField.func_146206_l()) {
            if (par2 == 15) {
                this.zTextField.func_146195_b(false);
                this.yawTextField.func_146195_b(true);
            }
            this.zTextField.func_146201_a(par1, par2);
        } else if (this.yawTextField.func_146206_l()) {
            if (par2 == 15) {
                this.yawTextField.func_146195_b(false);
                this.charTextField.func_146195_b(true);
            }
            this.yawTextField.func_146180_a(this.yaw);
            this.yawTextField.func_146201_a(par1, par2);
            this.fieldValidator.validate(this.yawTextField);
            this.yaw = this.yawTextField.func_146179_b();
        } else if (this.charTextField.func_146206_l()) {
            if (par2 == 15) {
                this.charTextField.func_146195_b(false);
                this.nameTextField.func_146195_b(true);
            }
            this.charTextField.func_146180_a(this.initial);
            if (par2 != 57) {
                this.charTextField.func_146201_a(par1, par2);
            }
            this.initial = this.charTextField.func_146179_b();
        }
        if (par2 == 28 || par2 == 156) {
            this.func_146284_a((GuiButton)this.field_146292_n.get(0));
        }
        this.checkFields();
        this.updateConfirmButton();
        super.func_73869_a(par1, par2);
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.nameTextField.func_146179_b().length() > 0 && this.initial.length() > 0 && this.xTextField.func_146179_b().length() > 0 && this.yTextField.func_146179_b().length() > 0 && this.zTextField.func_146179_b().length() > 0;
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        this.initial = this.initial.toUpperCase();
        if (this.initial.length() > 1) {
            this.initial = this.initial.substring(0, 1);
            this.charTextField.func_146180_a(this.initial);
        }
        if (this.yaw.length() > 4) {
            this.yaw = this.yaw.substring(0, 4);
            this.yawTextField.func_146180_a(this.yaw);
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        super.func_73864_a(par1, par2, par3);
        this.nameTextField.func_146192_a(par1, par2, par3);
        this.xTextField.func_146192_a(par1, par2, par3);
        this.yTextField.func_146192_a(par1, par2, par3);
        this.zTextField.func_146192_a(par1, par2, par3);
        this.yawTextField.func_146192_a(par1, par2, par3);
        this.charTextField.func_146192_a(par1, par2, par3);
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased(par1, par2, par3, this.field_146295_m);
        }
    }

    public void func_73876_c() {
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.charTextField.func_146178_a();
        if (this.yawTextField.func_146206_l() || this.yaw.length() > 0) {
            this.yawTextField.func_146180_a(this.yaw);
        } else {
            this.yawTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
        }
        if (this.charTextField.func_146206_l() || this.initial.length() > 0) {
            this.charTextField.func_146180_a(this.initial);
        } else {
            this.charTextField.func_146180_a("\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton.field_146127_k < 100 && par1GuiButton instanceof MySmallButton) {
                try {
                    this.modMain.getSettings().setOptionValue(((MySmallButton)par1GuiButton).returnModOptions(), 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                par1GuiButton.field_146126_j = this.modMain.getSettings().getKeyBinding(ModOptions.getModOptions(par1GuiButton.field_146127_k));
            }
            if (par1GuiButton.field_146127_k == 200) {
                int x = this.xTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.xTextField.func_146179_b());
                int y = this.yTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.yTextField.func_146179_b());
                int z = this.zTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.zTextField.func_146179_b());
                String name = this.nameTextField.func_146179_b();
                Waypoint created = new Waypoint(x, y, z, name, this.initial, this.color);
                if (this.waypointDisabled) {
                    created.setDisabled(true);
                }
                if (this.yaw.length() > 0 && !this.yaw.equals("-")) {
                    created.setRotation(true);
                    created.setYaw(Integer.parseInt(this.yawTextField.func_146179_b()));
                }
                WaypointWorld sourceWorld = this.defaultWorld;
                WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
                String[] destinationWorldKeys = this.worlds.getCurrentKeys();
                String destinationSetKey = this.sets.getCurrentSetKey();
                WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
                WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
                if (this.point != null && sourceSet == destinationSet && destinationSet.getList().contains(this.point)) {
                    destinationSet.getList().add(destinationSet.getList().indexOf(this.point), created);
                } else {
                    destinationSet.getList().add(created);
                }
                if (this.point != null) {
                    sourceSet.getList().remove(this.point);
                }
                try {
                    this.modMain.getSettings().saveWaypoints(sourceWorld);
                    if (destinationWorld != sourceWorld) {
                        this.modMain.getSettings().saveWaypoints(destinationWorld);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 202) {
                this.color = (this.color + 1) % (ModSettings.ENCHANT_COLORS.length - 1);
            }
            if (par1GuiButton.field_146127_k == 203) {
                this.multiplyCoordinates(8.0);
            } else if (par1GuiButton.field_146127_k == 204) {
                this.multiplyCoordinates(0.125);
            }
            if (par1GuiButton.field_146127_k == 205) {
                this.waypointDisabled = !this.waypointDisabled;
                String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
                String string = this.disableButton.field_146126_j = this.waypointDisabled ? enabledisable[1] : enabledisable[0];
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    public List getButtons() {
        return this.field_146292_n;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        this.nameTextField.func_146194_f();
        this.xTextField.func_146194_f();
        this.yTextField.func_146194_f();
        this.zTextField.func_146194_f();
        this.yawTextField.func_146194_f();
        this.charTextField.func_146194_f();
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(par1, par2, this.field_146295_m);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(par1, par2, this.field_146295_m);
        }
    }

    private void multiplyCoordinates(double factor) {
        this.multiplyCoordinateField(this.xTextField, factor);
        this.multiplyCoordinateField(this.zTextField, factor);
    }

    private void multiplyCoordinateField(GuiTextField field, double factor) {
        if (field.func_146179_b().isEmpty() || field.func_146179_b().equals("-")) {
            return;
        }
        int value = Integer.parseInt(field.func_146179_b());
        value = (int)Math.floor((double)value * factor);
        field.func_146180_a("" + value);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return;
            }
        }
    }

    @Override
    public void onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.color = selected;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld);
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId());
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, this.waypointsManager.getWorld(worldKeys[0], worldKeys[1]));
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
    }
}

