/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.api.heavysieve;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.blay09.mods.excompressum.api.ExCompressumAPI;
import net.blay09.mods.excompressum.api.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.api.sievemesh.SieveMeshRegistryEntry;
import net.minecraft.block.state.IBlockState;

public class HeavySieveRegistryEntry {
    private final IBlockState inputState;
    private final boolean isWildcard;
    private final List<HeavySieveReward> rewards = Lists.newArrayList();
    private final ArrayListMultimap<Integer, HeavySieveReward> meshRewards = ArrayListMultimap.create();

    public HeavySieveRegistryEntry(IBlockState input, boolean isWildcard) {
        this.inputState = input;
        this.isWildcard = isWildcard;
    }

    public IBlockState getInputState() {
        return this.inputState;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public List<HeavySieveReward> getRewards() {
        return this.rewards;
    }

    @Deprecated
    public List<HeavySieveReward> getRewardsForMesh(SieveMeshRegistryEntry sieveMesh) {
        return this.getRewardsForMesh(sieveMesh, false);
    }

    public List<HeavySieveReward> getRewardsForMesh(SieveMeshRegistryEntry sieveMesh, boolean flattenSieveRecipes) {
        if (!ExCompressumAPI.getExNihilo().doMeshesSplitLootTables()) {
            return this.rewards;
        }
        if (flattenSieveRecipes) {
            return this.rewards.stream().filter(it -> sieveMesh.getMeshLevel() >= it.getMeshLevel()).collect(Collectors.toList());
        }
        return this.meshRewards.get((Object)sieveMesh.getMeshLevel());
    }

    public void addReward(HeavySieveReward reward) {
        this.rewards.add(reward);
        if (ExCompressumAPI.getExNihilo().doMeshesSplitLootTables()) {
            this.meshRewards.put((Object)reward.getMeshLevel(), (Object)reward);
        }
    }

    public void addRewards(Collection<HeavySieveReward> rewards) {
        this.rewards.addAll(rewards);
        if (ExCompressumAPI.getExNihilo().doMeshesSplitLootTables()) {
            for (HeavySieveReward reward : rewards) {
                this.meshRewards.put((Object)reward.getMeshLevel(), (Object)reward);
            }
        }
    }
}

