/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import com.google.common.collect.HashMultiset;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.blay09.mods.excompressum.api.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.compat.jei.HeavySieveRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HeavySieveRecipeCategory
implements IRecipeCategory<HeavySieveRecipe> {
    public static final String UID = "excompressum:heavySieve";
    private static final ResourceLocation texture = new ResourceLocation("excompressum", "textures/gui/jei_heavy_sieve.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public HeavySieveRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 129);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.excompressum:heavySieve", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Ex Compressum";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, HeavySieveRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 61, 9);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        recipeLayout.getItemStacks().init(1, true, 87, 9);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getInputs(ItemStack.class).get(1));
        IFocus focus = recipeLayout.getFocus();
        this.hasHighlight = focus != null && focus.getMode() == IFocus.Mode.OUTPUT;
        List outputs = ingredients.getOutputs(ItemStack.class);
        int INPUT_SLOTS = 2;
        int slotNumber = 0;
        for (List output : outputs) {
            int slotX = 2 + slotNumber % 9 * 18;
            int slotY = 36 + slotNumber / 9 * 18;
            recipeLayout.getItemStacks().init(2 + slotNumber, false, slotX, slotY);
            recipeLayout.getItemStacks().set(2 + slotNumber, output);
            if (focus != null) {
                ItemStack focusStack;
                Object focusValue = focus.getValue();
                if (focus.getMode() == IFocus.Mode.OUTPUT && focusValue instanceof ItemStack && (focusStack = (ItemStack)focusValue).func_77973_b() == ((ItemStack)output.get(0)).func_77973_b() && focusStack.func_77952_i() == ((ItemStack)output.get(0)).func_77952_i()) {
                    this.highlightX = slotX;
                    this.highlightY = slotY;
                }
            }
            ++slotNumber;
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!input) {
                HashMultiset condensedTooltips = HashMultiset.create();
                for (HeavySieveReward reward : recipeWrapper.getRewardsForItemStack((ItemStack)ingredient)) {
                    int iChance = (int)(reward.getBaseChance() * 100.0f);
                    String s = iChance > 0 ? String.format("%3d%%", (int)(reward.getBaseChance() * 100.0f)) : String.format("%1.1f%%", Float.valueOf(reward.getBaseChance() * 100.0f));
                    condensedTooltips.add((Object)s);
                }
                tooltip.add(I18n.func_135052_a((String)"jei.excompressum:heavySieve.dropChance", (Object[])new Object[0]));
                for (String line : condensedTooltips.elementSet()) {
                    tooltip.add(" * " + condensedTooltips.count((Object)line) + "x " + line);
                }
            }
        });
    }
}

