/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.blay09.mods.excompressum.api.woodencrucible.WoodenCrucibleRegistryEntry;
import net.blay09.mods.excompressum.compat.jei.WoodenCrucibleRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class WoodenCrucibleRecipeCategory
implements IRecipeCategory<WoodenCrucibleRecipe> {
    public static final String UID = "excompressum:woodenCrucible";
    private static final ResourceLocation texture = new ResourceLocation("excompressum", "textures/gui/jei_wooden_crucible.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public WoodenCrucibleRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 129);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.excompressum:woodenCrucible", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Ex Compressum";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, WoodenCrucibleRecipe recipeWrapper, IIngredients ingredients) {
        ItemStack fluidItem;
        if (FluidRegistry.isUniversalBucketEnabled()) {
            fluidItem = new ItemStack(Items.field_151133_ar);
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)fluidItem);
            if (fluidHandler != null) {
                fluidHandler.fill((FluidStack)((List)ingredients.getOutputs(FluidStack.class).get(0)).get(0), true);
                fluidItem = fluidHandler.getContainer();
            }
        } else {
            fluidItem = new ItemStack(Items.field_151131_as);
        }
        recipeLayout.getItemStacks().init(0, false, 74, 9);
        recipeLayout.getItemStacks().set(0, fluidItem);
        IFocus focus = recipeLayout.getFocus();
        boolean hasFocus = focus != null && focus.getMode() == IFocus.Mode.INPUT;
        this.hasHighlight = false;
        List inputs = ingredients.getInputs(ItemStack.class);
        boolean INPUT_SLOTS = true;
        int slotNumber = 0;
        for (List input2 : inputs) {
            int slotX = 2 + slotNumber % 9 * 18;
            int slotY = 36 + slotNumber / 9 * 18;
            recipeLayout.getItemStacks().init(1 + slotNumber, true, slotX, slotY);
            recipeLayout.getItemStacks().set(1 + slotNumber, input2);
            if (focus != null) {
                Object focusValue = focus.getValue();
                if (hasFocus && focusValue instanceof ItemStack) {
                    ItemStack focusStack = (ItemStack)focus.getValue();
                    for (ItemStack inputVariant : input2) {
                        if (focusStack.func_77973_b() != inputVariant.func_77973_b() || focusStack.func_77952_i() != inputVariant.func_77952_i()) continue;
                        this.hasHighlight = true;
                        this.highlightX = slotX;
                        this.highlightY = slotY;
                        break;
                    }
                }
            }
            ++slotNumber;
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (input) {
                WoodenCrucibleRegistryEntry entry = recipeWrapper.getEntryAt(slotIndex - 1);
                tooltip.add(recipeWrapper.getFluid().getLocalizedName((FluidStack)((List)ingredients.getOutputs(FluidStack.class).get(0)).get(0)));
                tooltip.add(" * " + entry.getAmount() + " mB");
            }
        });
    }
}

