/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.tconstruct;

import java.util.Collection;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.compressedhammer.CompressedHammerRegistry;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class ModSmashingII
extends ModifierTrait {
    private static final float SPEED_DECREASE = 0.5f;
    private static final float DAMAGE_INCREASE = 3.0f;

    public ModSmashingII() {
        super("excompressum:smashingii", 0xFF0000);
    }

    public boolean canApplyTogether(Enchantment enchantment) {
        return enchantment != Enchantments.field_185306_r;
    }

    public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
        super.miningSpeed(tool, event);
        event.setNewSpeed(Math.max(0.1f, event.getNewSpeed() - 0.5f));
    }

    public float damage(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, float newDamage, boolean isCritical) {
        return damage + 3.0f;
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        Collection<ItemStack> rewards = CompressedHammerRegistry.rollHammerRewards(event.getState(), (float)event.getFortuneLevel(), event.getHarvester().field_70170_p.field_73012_v);
        if (rewards.isEmpty() && (rewards = ExRegistro.rollHammerRewards(event.getState(), ToolHelper.getHarvestLevelStat((ItemStack)tool), (float)event.getFortuneLevel(), event.getHarvester().field_70170_p.field_73012_v)).isEmpty()) {
            return;
        }
        event.getDrops().clear();
        event.setDropChance(1.0f);
        for (ItemStack itemStack : rewards) {
            event.getDrops().add(itemStack);
        }
    }

    public void apply(NBTTagCompound root) {
        super.apply(root);
        NBTTagList traits = TagUtil.getTraitsTagList((NBTTagCompound)root);
        int compressingIndex = -1;
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            if (!traits.func_150307_f(i).equals("excompressum:compressing")) continue;
            compressingIndex = i;
        }
        if (compressingIndex != -1) {
            traits.func_74742_a(traits.func_74744_a(compressingIndex));
            TagUtil.setTraitsTagList((NBTTagCompound)root, (NBTTagList)traits);
        }
    }
}

