/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.handler.ChickenStickHandler;
import net.blay09.mods.excompressum.registry.chickenstick.ChickenStickRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemChickenStick
extends ItemTool {
    public static final String name = "chicken_stick";
    public static final ResourceLocation registryName = new ResourceLocation("excompressum", "chicken_stick");

    public ItemChickenStick() {
        super(0.0f, 0.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77655_b(registryName.toString());
        this.func_77637_a(ExCompressum.creativeTab);
        this.func_77656_e(0);
        this.field_77865_bY = 0.0f;
    }

    public String func_77653_i(ItemStack itemStack) {
        String chickenStickName = ChickenStickHandler.chickenStickName;
        return chickenStickName != null ? chickenStickName : super.func_77653_i(itemStack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (ChickenStickHandler.chickenStickName != null) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"item.excompressum:chicken_stick.name", (Object[])new Object[0]));
        }
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase attacker, EntityLivingBase target) {
        this.playChickenSound(attacker.field_70170_p, new BlockPos(attacker.field_70165_t, attacker.field_70163_u, attacker.field_70161_v));
        return super.func_77644_a(itemStack, attacker, target);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        this.playChickenSound(world, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return ChickenStickRegistry.isHammerable(state);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (ChickenStickRegistry.isHammerable(state)) {
            if (this.isAngry(stack)) {
                return this.field_77864_a * 1.5f;
            }
            return this.field_77864_a;
        }
        return 0.8f;
    }

    public int func_77619_b() {
        return 0;
    }

    public void playChickenSound(World world, BlockPos pos) {
        if (world.field_73012_v.nextFloat() <= ModConfig.tools.chickenStickSoundChance) {
            ResourceLocation location = null;
            if (ModConfig.tools.chickenStickSounds.length > 0) {
                location = new ResourceLocation(ModConfig.tools.chickenStickSounds[world.field_73012_v.nextInt(ModConfig.tools.chickenStickSounds.length)]);
            }
            if (location != null) {
                SoundEvent soundEvent = (SoundEvent)SoundEvent.field_187505_a.func_82594_a(location);
                if (soundEvent != null) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, soundEvent, SoundCategory.PLAYERS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                } else {
                    ExCompressum.logger.warn("Chicken Stick tried to play a sound that does not exist: {}", (Object)location);
                }
            }
        }
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isAngry(stack);
    }

    public boolean isAngry(ItemStack itemStack) {
        return itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74767_n("IsAngry");
    }
}

