/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry.compressor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class CompressedRecipeRegistry {
    private static final List<CompressedRecipe> recipesSmall = Lists.newArrayList();
    private static final List<CompressedRecipe> recipes = Lists.newArrayList();
    private static final Map<RegistryKey, CompressedRecipe> cachedResults = Maps.newHashMap();

    public static void reload() {
        cachedResults.clear();
        recipesSmall.clear();
        recipes.clear();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            NonNullList ingredients = recipe.func_192400_c();
            int count = ingredients.size();
            if (count != 4 && count != 9) continue;
            Ingredient first = (Ingredient)ingredients.get(0);
            boolean passes = true;
            for (int i = 1; i < count; ++i) {
                Ingredient other = (Ingredient)ingredients.get(i);
                boolean passesInner = false;
                for (ItemStack itemStack : other.func_193365_a()) {
                    if (!first.apply(itemStack)) continue;
                    passesInner = true;
                    break;
                }
                if (passesInner) continue;
                passes = false;
                break;
            }
            if (count == 4 && recipe.func_194133_a(2, 2)) {
                if (!passes) continue;
                recipesSmall.add(new CompressedRecipe(first, 4, recipe.func_77571_b().func_77946_l()));
                continue;
            }
            if (count != 9 || !recipe.func_194133_a(3, 3) || !passes) continue;
            recipes.add(new CompressedRecipe(first, 9, recipe.func_77571_b().func_77946_l()));
        }
    }

    @Nullable
    public static CompressedRecipe getRecipe(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return null;
        }
        RegistryKey key = new RegistryKey(itemStack);
        CompressedRecipe foundRecipe = cachedResults.get(key);
        if (foundRecipe != null) {
            return foundRecipe;
        }
        for (CompressedRecipe recipe : recipes) {
            if (!recipe.getIngredient().apply(itemStack)) continue;
            cachedResults.put(key, recipe);
            return recipe;
        }
        for (CompressedRecipe recipe : recipesSmall) {
            if (!recipe.getIngredient().apply(itemStack)) continue;
            cachedResults.put(key, recipe);
            return recipe;
        }
        cachedResults.put(key, null);
        return null;
    }
}

