/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import javax.annotation.Nullable;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.tile.TileAutoSieveBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaReceiver;

@Optional.Interface(modid="botania", iface="vazkii.botania.api.mana.IManaReceiver", striprefs=true)
public class TileAutoSieveMana
extends TileAutoSieveBase
implements IManaReceiver {
    private int manaStored;

    @Override
    public int getEffectiveEnergy() {
        return ModConfig.compat.manaSieveCost;
    }

    @Override
    public int getMaxEnergyStored() {
        return ModConfig.compat.manaSieveCost * 1600;
    }

    @Override
    public int getEnergyStored(@Nullable EnumFacing from) {
        return this.manaStored;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int manaExtracted = Math.min(this.manaStored, maxExtract);
        if (!simulate) {
            this.manaStored -= manaExtracted;
        }
        return manaExtracted;
    }

    @Override
    public void setEnergyStored(int energy) {
        this.manaStored = energy;
    }

    @Override
    protected void writeToNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        super.writeToNBTSynced(tagCompound, isSync);
        if (!isSync) {
            tagCompound.func_74768_a("ManaStored", this.manaStored);
        }
    }

    @Override
    protected void readFromNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        super.readFromNBTSynced(tagCompound, isSync);
        if (!isSync) {
            this.manaStored = tagCompound.func_74762_e("ManaStored");
        }
    }

    public boolean isFull() {
        return this.manaStored >= this.getMaxEnergyStored();
    }

    public void recieveMana(int mana) {
        this.manaStored += mana;
    }

    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public int getCurrentMana() {
        return this.manaStored;
    }
}

