/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import javax.annotation.Nullable;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.api.woodencrucible.WoodenCrucibleRegistryEntry;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWoodenCrucible
extends TileEntity
implements ITickable {
    private static final int RAIN_FILL_INTERVAL = 20;
    private static final int MELT_INTERVAL = 20;
    private static final int RAIN_FILL_SPEED = 8;
    private static final int SYNC_INTERVAL = 10;
    private ItemStackHandler itemHandler = new ItemStackHandler(1){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack copy = stack.func_77946_l();
            if (TileWoodenCrucible.this.addItem(copy, true, simulate)) {
                return copy.func_190926_b() ? ItemStack.field_190927_a : copy;
            }
            return stack;
        }
    };
    private FluidTank fluidTank = new FluidTank(1999){

        public int fill(FluidStack resource, boolean doFill) {
            int result = super.fill(resource, doFill);
            if (this.fluid != null && this.fluid.amount > 1000) {
                this.fluid.amount = 1000;
            }
            return result;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean canFill() {
            return TileWoodenCrucible.this.itemHandler.getStackInSlot(0).func_190926_b();
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return super.canFillFluidType(fluid) && fluid.getFluid().getTemperature() <= 300;
        }

        protected void onContentsChanged() {
            TileWoodenCrucible.this.func_70296_d();
            TileWoodenCrucible.this.isDirty = true;
        }
    };
    private int ticksSinceSync;
    private boolean isDirty;
    private int ticksSinceRain;
    private int ticksSinceMelt;
    private WoodenCrucibleRegistryEntry currentMeltable;
    private int solidVolume;

    public boolean addItem(ItemStack itemStack, boolean isAutomated, boolean simulate) {
        if (this.fluidTank.getFluidAmount() >= 1000 && ExRegistro.isNihiloItem(itemStack, ExNihiloProvider.NihiloItems.DUST)) {
            itemStack.func_190918_g(1);
            if (!simulate) {
                this.itemHandler.setStackInSlot(0, new ItemStack(Blocks.field_150435_aG));
                this.fluidTank.setFluid(null);
                VanillaPacketHandler.sendTileEntityUpdate(this);
            }
            return true;
        }
        WoodenCrucibleRegistryEntry meltable = WoodenCrucibleRegistry.getEntry(itemStack);
        if (meltable != null && (this.fluidTank.getFluid() == null || this.fluidTank.getFluidAmount() == 0 || this.fluidTank.getFluid().getFluid() == meltable.getFluid())) {
            int capacityLeft = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount() - this.solidVolume;
            if (isAutomated && capacityLeft >= meltable.getAmount() || !isAutomated && capacityLeft > 0) {
                itemStack.func_190918_g(1);
                if (!simulate) {
                    this.currentMeltable = meltable;
                    this.solidVolume += Math.min(capacityLeft, meltable.getAmount());
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                }
                return true;
            }
        }
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_72912_H().func_76059_o() && this.field_145850_b.func_175710_j(this.field_174879_c) && this.field_145850_b.getBiomeForCoordsBody(this.field_174879_c).func_76727_i() > 0.0f) {
                ++this.ticksSinceRain;
                if (this.ticksSinceRain >= 20) {
                    this.fluidTank.fill(new FluidStack(FluidRegistry.WATER, 8), true);
                    this.ticksSinceRain = 0;
                }
            }
            if (this.currentMeltable != null) {
                ++this.ticksSinceMelt;
                if (this.ticksSinceMelt >= 20 && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
                    int amount = Math.min(ModConfig.automation.woodenCrucibleSpeed, this.solidVolume);
                    this.fluidTank.fill(new FluidStack(this.currentMeltable.getFluid(), amount), true);
                    this.solidVolume = Math.max(0, this.solidVolume - amount);
                    this.ticksSinceMelt = 0;
                    this.isDirty = true;
                }
            }
            ++this.ticksSinceSync;
            if (this.ticksSinceSync >= 10) {
                this.ticksSinceSync = 0;
                if (this.isDirty) {
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.isDirty = false;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.solidVolume = tagCompound.func_74762_e("SolidVolume");
        this.fluidTank.readFromNBT(tagCompound.func_74775_l("FluidTank"));
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        if (tagCompound.func_74764_b("Content")) {
            this.currentMeltable = WoodenCrucibleRegistry.getEntry(new ItemStack(tagCompound.func_74775_l("Content")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.currentMeltable != null) {
            tagCompound.func_74782_a("Content", (NBTBase)this.currentMeltable.getItemStack().func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74768_a("SolidVolume", this.solidVolume);
        tagCompound.func_74782_a("FluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        tagCompound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        return tagCompound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidTank;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public int getSolidVolume() {
        return this.solidVolume;
    }

    public int getSolidCapacity() {
        return this.fluidTank.getCapacity();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

