/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.gui;

import bre.smoothfont.FontRendererHook;
import bre.smoothfont.FontRendererHookList;
import bre.smoothfont.FontTextureManager;
import bre.smoothfont.FontUtils;
import bre.smoothfont.config.CommonConfig;
import bre.smoothfont.config.GlobalConfig;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class GuiCommon {
    private static Minecraft mc = Minecraft.func_71410_x();
    public static int wrapwidth = 50;

    public static String getStringOnOff(boolean flag) {
        return flag ? I18n.func_135052_a((String)"smoothfont.config.ON", (Object[])new Object[0]) : I18n.func_135052_a((String)"smoothfont.config.OFF", (Object[])new Object[0]);
    }

    private static void drawSampleStringCentered(GuiScreen gui, int posX, int posY, float scale) {
        ScaledResolution scaledRes = new ScaledResolution(mc);
        FontRendererHook frh = FontRendererHookList.getFontRendererHook(GuiCommon.mc.field_71466_p);
        boolean osFont = frh != null ? frh.changeFont : CommonConfig.currentConfig.useOSFont;
        float fontRes = mc.func_152349_b() ? (float)FontTextureManager.getInstance().getUnicodeFontRes(osFont) : (float)FontTextureManager.getInstance().getDefaultFontRes(GuiCommon.mc.field_71466_p.field_111273_g, osFont);
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)0.0f);
        float fontScale = (float)(scaledRes.func_78325_e() * 8) / fontRes * scale;
        if (frh != null && frh.disableFeatures) {
            gui.func_73732_a(GuiCommon.mc.field_71466_p, FontUtils.getCurrentLangStr() + " ABCabc123 (x???)", (int)((float)posX / scale), (int)((float)posY / scale), 0xFFFFFF);
        } else {
            gui.func_73732_a(GuiCommon.mc.field_71466_p, FontUtils.getCurrentLangStr() + String.format(" ABCabc123 (x%.2f)", Float.valueOf(fontScale)), (int)((float)posX / scale), (int)((float)posY / scale), 0xFFFFFF);
        }
        GL11.glPopMatrix();
    }

    private static void drawDebugSampleString(GuiScreen gui, int x, int y, float scale) {
        int posX = x;
        int posY = y;
        FontRenderer renderer = GuiCommon.mc.field_71466_p;
        FontRendererHook frh = FontRendererHookList.getFontRendererHook(renderer);
        String sampleStr = "ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890";
        int strWidth = GuiCommon.mc.field_71466_p.func_78256_a("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890");
        int charsWidthInt = 0;
        int charsWidthRound = 0;
        for (int i = 0; i < "ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890".length(); ++i) {
            charsWidthInt += renderer.func_78263_a("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890".charAt(i));
            charsWidthRound += Math.round(frh.getCharWidthFloatTest("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890".charAt(i)));
        }
        renderer.func_78276_b("getStringWidth() = " + strWidth, x, y, -1);
        renderer.func_78276_b("Total (int)getCharWidth() = " + charsWidthInt, x, y += renderer.field_78288_b, -1);
        renderer.func_78276_b("Total (round)getCharWidth() = " + charsWidthRound, x, y += renderer.field_78288_b, -1);
        renderer.func_78276_b("getStringWidth():", x, y += renderer.field_78288_b, -1);
        Gui.func_73734_a((int)(x + 10), (int)(y += renderer.field_78288_b), (int)(x + 10 + strWidth), (int)(y + renderer.field_78288_b), (int)-65536);
        renderer.func_78276_b("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890", x + 10, y, -1);
        renderer.func_78276_b("Total getCharWidth():", x, y += renderer.field_78288_b, -1);
        Gui.func_73734_a((int)(x + 10), (int)(y += renderer.field_78288_b), (int)(x + 10 + charsWidthInt), (int)(y + renderer.field_78288_b), (int)-16742400);
        renderer.func_78276_b("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890", x + 10, y, -1);
        renderer.func_78276_b("Total (round)getCharWidthFloat():", x, y += renderer.field_78288_b, -1);
        Gui.func_73734_a((int)(x + 10), (int)(y += renderer.field_78288_b), (int)(x + 10 + charsWidthRound), (int)(y + renderer.field_78288_b), (int)-16776961);
        renderer.func_78276_b("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890", x + 10, y, -1);
        renderer.func_78276_b("trimStringToWidth(getStringToWidth()):", x, y += renderer.field_78288_b, -1);
        renderer.func_78276_b(renderer.func_78269_a("ABCDEFG WXYZ abcdefg wxyz \u30e6\u30cb\u30b3\u30fc\u30c9 \u6f22\u5b57 12345 67890", strWidth), x + 10, y += renderer.field_78288_b, -1);
        renderer.func_78279_b("This is test case of drawSplitString() ----------- hogehogehoge aabcde.", x, y += renderer.field_78288_b, wrapwidth, -1);
    }

    public static void drawSamples(GuiScreen gui, int posX, int posY, int scaleFactor) {
        int h = 10;
        int y = posY;
        if (GlobalConfig.hasDebugOption("debugSampleStrings")) {
            GuiCommon.drawDebugSampleString(gui, 10, posY, 1.0f);
            return;
        }
        float scale = 0.5f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
        scale = 0.75f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
        scale = 1.0f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
        scale = 1.25f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
        scale = 1.5f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
        scale = 1.75f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
        scale = 2.0f * (float)scaleFactor / 4.0f;
        GuiCommon.drawSampleStringCentered(gui, posX, y, scale);
        y = (int)((float)y + 10.0f * scale);
    }

    public static List strToList(FontRenderer fontRenderer, int maxWidth, String str) {
        ArrayList<String> list = new ArrayList<String>();
        String[] strs = str.split("\\\\n");
        list.add(strs[0]);
        for (int i = 1; i < strs.length; ++i) {
            if (i == 1) {
                strs[1] = ChatFormatting.GRAY + strs[1];
            }
            strs[i] = FontRenderer.func_78282_e((String)strs[i - 1]) + strs[i];
            list.addAll(fontRenderer.func_78271_c(strs[i], maxWidth));
        }
        return list;
    }
}

