/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.handler;

import bre.smoothfont.handler.TimerEventHandler;

public abstract class Timer {
    private boolean enabled;
    protected int period;
    private int remainingTime = 0;

    protected Timer(int timeout) {
        this.period = timeout;
        this.enabled = timeout > 0;
    }

    public void startTimer() {
        if (!this.enabled) {
            return;
        }
        this.resetTimer();
        TimerEventHandler.addTimer(this);
    }

    public void resetTimer() {
        if (!this.enabled) {
            return;
        }
        this.remainingTime = this.period;
    }

    protected boolean checkTimeout() {
        if (!this.enabled) {
            return false;
        }
        --this.remainingTime;
        if (this.remainingTime > 0) {
            return false;
        }
        this.timeoutProc();
        return true;
    }

    public abstract void timeoutProc();
}

