/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.MCUtils;
import p455w0rdslib.util.RenderUtils;

@SideOnly(value=Side.CLIENT)
public class GuiUtils {
    private static Minecraft mc() {
        return MCUtils.mc();
    }

    public static void bindTexture(String texturePath) {
        GuiUtils.bindTexture(new ResourceLocation(texturePath));
    }

    public static void bindTexture(String domain, String texturePath) {
        GuiUtils.bindTexture(new ResourceLocation(domain, texturePath));
    }

    public static void bindTexture(ResourceLocation location) {
        RenderUtils.getTextureManager().func_110577_a(location);
    }

    public static void drawItem(ItemStack item, int x, int y) {
        RenderHelper.func_74520_c();
        RenderUtils.getRenderItem().func_180450_b(item, x, y);
        RenderHelper.func_74518_a();
    }

    public static void drawFluid(Gui gui, int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        GuiUtils.setBlockTextureSheet();
        int colour = fluid.getFluid().getColor(fluid);
        GlStateManager.func_179131_c((float)(colour >> 16 & 0xFF), (float)(colour >> 8 & 0xFF), (float)(colour & 0xFF), (float)(colour >> 24 & 0xFF));
        GuiUtils.drawTiledTexture(gui, x, y, GuiUtils.getFluidTexture(fluid), width, height);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            fluid = FluidRegistry.LAVA;
        }
        return GuiUtils.getTexture(fluid.getStill());
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null || fluid.getFluid().getStill(fluid) == null) {
            fluid = new FluidStack(FluidRegistry.LAVA, 1);
        }
        return GuiUtils.getTexture(fluid.getFluid().getStill(fluid));
    }

    public static TextureAtlasSprite getTexture(ResourceLocation location) {
        return GuiUtils.getTexture(location.toString());
    }

    public static TextureAtlasSprite getTexture(String location) {
        return GuiUtils.textureMap().func_110572_b(location);
    }

    public static TextureMap textureMap() {
        return GuiUtils.mc().func_147117_R();
    }

    public static void setBlockTextureSheet() {
        GuiUtils.bindTexture(new ResourceLocation("textures/atlas/blocks.png"));
    }

    public static void drawTiledTexture(Gui gui, int x, int y, TextureAtlasSprite icon, int width, int height) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = Math.min(width - i, 16);
                drawHeight = Math.min(height - j, 16);
                GuiUtils.drawScaledTexturedModelRectFromIcon(gui, x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawScaledTexturedModelRectFromIcon(Gui gui, int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)(x + 0), (double)(y + height), (double)gui.field_73735_i).func_187315_a(minU, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), (double)gui.field_73735_i).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + 0), (double)gui.field_73735_i).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV).func_181675_d();
        buffer.func_181662_b((double)(x + 0), (double)(y + 0), (double)gui.field_73735_i).func_187315_a(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawVanillaTooltip(GuiScreen gui, List<String> text, int x, int y) {
        GuiUtils.drawHoveringText(gui, text, x, y, RenderUtils.getFontRenderer(), -267386864, 0x505000FF, 1344798847);
    }

    public static void drawToolTipWithBorderColor(GuiScreen gui, List<String> text, int x, int y, int borderColor1, int borderColor2) {
        GuiUtils.drawHoveringText(gui, text, x, y, RenderUtils.getFontRenderer(), -267386864, borderColor1, borderColor2);
    }

    public static void drawContinuousTexturedBox(Gui gui, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize) {
        GuiUtils.drawContinuousTexturedBox(gui, res, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize);
    }

    public static void drawContinuousTexturedBox(Gui gui, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        GuiUtils.bindTexture(res);
        GuiUtils.drawContinuousTexturedBox(gui, x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder);
    }

    public static void drawContinuousTexturedBox(Gui gui, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        float zLevel = gui.field_73735_i;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawHoveringText(GuiScreen gui, List<String> textLines, int x, int y, FontRenderer font, int backgroundColor, int borderColor1, int borderColor2) {
        if (!textLines.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179097_i();
            int i = 0;
            for (String s : textLines) {
                int j = RenderUtils.getFontRenderer().func_78256_a(s);
                if (j <= i) continue;
                i = j;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10;
            }
            if (l1 + i > gui.field_146294_l) {
                l1 -= 28 + i;
            }
            if (i2 + k + 8 > gui.field_146295_m) {
                i2 = gui.field_146295_m - k - 8;
            }
            gui.field_73735_i = 300.0f;
            gui.field_146296_j.field_77023_b = 300.0f;
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, borderColor1, borderColor2);
            GuiUtils.drawGradientRect((Gui)gui, l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, borderColor1, borderColor2);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, borderColor1, borderColor1);
            GuiUtils.drawGradientRect((Gui)gui, l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, borderColor2, borderColor2);
            for (int k1 = 0; k1 < textLines.size(); ++k1) {
                String s1 = textLines.get(k1);
                RenderUtils.getFontRenderer().func_175063_a(s1, (float)l1, (float)i2, -1);
                if (k1 == 0) {
                    i2 += 2;
                }
                i2 += 10;
            }
            gui.field_73735_i = 0.0f;
            gui.field_146296_j.field_77023_b = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            GlStateManager.func_179121_F();
        }
    }

    public static void drawCenteredString(String text, int x, int y, int color) {
        RenderUtils.getFontRenderer().func_175063_a(text, (float)(x - RenderUtils.getFontRenderer().func_78256_a(text) / 2), (float)y, color);
    }

    public static void drawScaledString(String text, int x, int y, float scale, int color) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        RenderUtils.getFontRenderer().func_175063_a(text, (float)x, (float)y, color);
        GlStateManager.func_179121_F();
    }

    public static void drawStringNoShadow(String text, int x, int y, int color) {
        RenderUtils.getFontRenderer().func_175065_a(text, (float)x, (float)y, color, false);
    }

    public static void drawGradientRect(Gui gui, int left, int top, int right, int bottom, int startColor, int endColor) {
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)right, (double)top, (double)gui.field_73735_i).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, (double)gui.field_73735_i).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)bottom, (double)gui.field_73735_i).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, (double)gui.field_73735_i).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawSlot(GuiContainer gui, Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = EasyMappings.slotPosX(slotIn);
        int j = EasyMappings.slotPosY(slotIn);
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == gui.field_147005_v && gui.field_147012_x != null && !gui.field_147004_w;
        ItemStack itemstack1 = EasyMappings.player().field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == gui.field_147005_v && gui.field_147012_x != null && gui.field_147004_w && itemstack != null) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (gui.field_147007_t && gui.field_147008_s.contains(slotIn) && itemstack1 != null) {
            if (gui.field_147008_s.size() == 1) {
                return;
            }
            if (Container.func_94527_a((Slot)slotIn, (ItemStack)itemstack1, (boolean)true) && gui.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a((Set)gui.field_147008_s, (int)gui.field_146987_F, (ItemStack)itemstack, (int)(slotIn.func_75211_c() == null ? 0 : slotIn.func_75211_c().func_190916_E()));
                if (itemstack.func_190916_E() > itemstack.func_77976_d()) {
                    s = TextFormatting.YELLOW + "" + itemstack.func_77976_d();
                    itemstack.func_190920_e(itemstack.func_77976_d());
                }
                if (itemstack.func_190916_E() > slotIn.func_178170_b(itemstack)) {
                    s = TextFormatting.YELLOW + "" + slotIn.func_178170_b(itemstack);
                    itemstack.func_190920_e(slotIn.func_178170_b(itemstack));
                }
            } else {
                gui.field_147008_s.remove(slotIn);
                GuiUtils.updateDragSplitting(gui);
            }
        }
        gui.field_73735_i = 100.0f;
        gui.field_146296_j.field_77023_b = 100.0f;
        if (itemstack == null && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            GuiUtils.bindTexture(slotIn.getBackgroundLocation());
            GuiUtils.drawTexturedModalRect((Gui)gui, i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                Gui.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            Minecraft.func_71410_x().func_175599_af().func_180450_b(itemstack, i, j);
            gui.field_146296_j.func_180453_a(RenderUtils.getFontRenderer(), itemstack, i, j, s);
        }
        gui.field_73735_i = 0.0f;
        gui.field_146296_j.field_77023_b = 0.0f;
    }

    public static void drawTexturedModalRect(Gui gui, int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), (double)gui.field_73735_i).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)gui.field_73735_i).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), (double)gui.field_73735_i).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), (double)gui.field_73735_i).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void updateDragSplitting(GuiContainer gui) {
        ItemStack itemstack = EasyMappings.player().field_71071_by.func_70445_o();
        if (itemstack != null && gui.field_147007_t) {
            gui.field_146996_I = itemstack.func_190916_E();
            for (Slot slot : gui.field_147008_s) {
                ItemStack itemstack1 = itemstack.func_77946_l();
                int i = slot.func_75211_c() == null ? 0 : slot.func_75211_c().func_190916_E();
                Container.func_94525_a((Set)gui.field_147008_s, (int)gui.field_146987_F, (ItemStack)itemstack1, (int)i);
                if (itemstack1.func_190916_E() > itemstack1.func_77976_d()) {
                    itemstack1.func_190920_e(itemstack1.func_77976_d());
                }
                if (itemstack1.func_190916_E() > slot.func_178170_b(itemstack1)) {
                    itemstack1.func_190920_e(slot.func_178170_b(itemstack1));
                }
                gui.field_146996_I -= itemstack1.func_190916_E() - i;
            }
        }
    }

    public static void drawItemStack(GuiContainer gui, ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        gui.field_73735_i = 200.0f;
        gui.field_146296_j.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = RenderUtils.getFontRenderer();
        }
        gui.field_146296_j.func_180450_b(stack, x, y);
        gui.field_146296_j.func_180453_a(font, stack, x, y - (gui.field_147012_x == null ? 0 : 8), altText);
        gui.field_73735_i = 0.0f;
        gui.field_146296_j.field_77023_b = 0.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    public static Slot getSlotAtPos(int x, int y) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
            GuiContainer gui = (GuiContainer)Minecraft.func_71410_x().field_71462_r;
            for (int i = 0; i < gui.field_147002_h.field_75151_b.size(); ++i) {
                Slot slot = (Slot)gui.field_147002_h.field_75151_b.get(i);
                int rectX = slot.field_75223_e;
                int rectY = slot.field_75221_f;
                int pointX = x;
                int pointY = y;
                int i2 = gui.getGuiLeft();
                int j2 = gui.getGuiTop();
                if ((pointX -= i2) < rectX - 1 || pointX >= rectX + 16 + 1 || (pointY -= j2) < rectY - 1 || pointY >= rectY + 16 + 1 || !slot.func_111238_b()) continue;
                return slot;
            }
        }
        return null;
    }
}

