/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.legacy.base;

import com.elytradev.architecture.client.render.ICustomRenderer;
import com.elytradev.architecture.client.render.model.IArchitectureModel;
import com.elytradev.architecture.client.render.target.RenderTargetBase;
import com.elytradev.architecture.client.render.texture.ITexture;
import com.elytradev.architecture.common.block.BlockArchitecture;
import com.elytradev.architecture.common.helpers.Trans3;
import com.elytradev.architecture.common.helpers.Vector3;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ArchitectureModelRenderer
implements ICustomRenderer {
    protected IArchitectureModel model;
    protected ITexture[] textures;
    protected Vector3 origin;

    public ArchitectureModelRenderer(IArchitectureModel model, ITexture ... textures) {
        this(model, Vector3.zero, textures);
    }

    public ArchitectureModelRenderer(IArchitectureModel model, Vector3 origin, ITexture ... textures) {
        this.model = model;
        this.textures = textures;
        this.origin = origin;
    }

    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, RenderTargetBase target, BlockRenderLayer layer, Trans3 t) {
        BlockArchitecture block = (BlockArchitecture)state.func_177230_c();
        Trans3 t2 = t.t(block.localToGlobalTransformation(world, pos, state, Vector3.zero)).translate(this.origin);
        int colour = -1;
        this.model.render(t2, target, colour, colour, this.textures);
    }

    @Override
    public void renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, RenderTargetBase target, BlockRenderLayer layer, Trans3 t, boolean renderPrimary, boolean renderSecondary) {
        if (renderPrimary) {
            this.renderBlock(world, pos, state, target, layer, t);
        }
    }

    @Override
    public void renderItemStack(ItemStack stack, RenderTargetBase target, Trans3 t) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (block = Block.func_149634_a((Item)item)) instanceof BlockArchitecture) {
            t = t.t(((BlockArchitecture)block).itemTransformation());
        }
        this.model.render(t.translate(this.origin), target, -1, -1, this.textures);
    }

    private int getColourFromState(IBlockState state) {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        int color = blockColors.func_189991_a(state, null, null);
        return color;
    }
}

