/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.IObservableItemHandler;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.Validators;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class ConcreteItemStorage
extends ItemStackHandler
implements IObservableItemHandler {
    private final List<Runnable> listeners = Lists.newArrayList();
    private final List<Predicate<ItemStack>> validators = Lists.newArrayList();
    private final boolean[] extractMask;
    private String name = "Container";

    public ConcreteItemStorage(int slots) {
        super(slots);
        this.extractMask = new boolean[slots];
        Arrays.fill(this.extractMask, true);
    }

    public final ConcreteItemStorage withName(String name) {
        this.name = name;
        return this;
    }

    @SafeVarargs
    public final ConcreteItemStorage withValidators(Predicate<ItemStack> ... predicates) {
        this.validators.clear();
        Collections.addAll(this.validators, predicates);
        return this;
    }

    public final ConcreteItemStorage setCanExtract(int index, boolean canExtract) {
        if (index < this.extractMask.length) {
            this.extractMask[index] = canExtract;
        }
        return this;
    }

    public void markDirty() {
        this.listeners.forEach(Runnable::run);
    }

    @Override
    public void listen(@Nonnull Runnable r) {
        this.listeners.add(r);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = super.extractItem(slot, amount, simulate);
        if (!simulate) {
            this.markDirty();
        }
        return stack;
    }

    public ItemStack insertItem(int slot, ItemStack itemStack, boolean simulate) {
        ItemStack result = super.insertItem(slot, itemStack, simulate);
        if (!simulate) {
            this.markDirty();
        }
        return result;
    }

    public void setStackInSlot(int slot, ItemStack itemStack) {
        super.setStackInSlot(slot, itemStack);
        this.markDirty();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public boolean hasValidator(int slot) {
        return this.validators.size() > slot;
    }

    @Nonnull
    public Predicate<ItemStack> getValidator(int slot) {
        if (this.validators.size() <= slot) {
            return Validators.ANYTHING;
        }
        return this.validators.get(slot);
    }

    public boolean getCanExtract(int slot) {
        if (this.extractMask.length <= slot) {
            return false;
        }
        return this.extractMask[slot];
    }
}

