/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.client.GuiDrawing;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget.WWidget;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WBar
extends WWidget {
    private final ResourceLocation bg;
    private final ResourceLocation bar;
    private final int field;
    private final int max;
    private final IInventory inventory;
    private final Direction direction;
    private boolean renderTooltip;
    private String tooltipLabel;

    public WBar(ResourceLocation bg, ResourceLocation bar, IInventory inventory, int field, int maxfield) {
        this(bg, bar, inventory, field, maxfield, Direction.UP);
    }

    public WBar(ResourceLocation bg, ResourceLocation bar, IInventory inventory, int field, int maxfield, Direction dir) {
        this.bg = bg;
        this.bar = bar;
        this.inventory = inventory;
        this.field = field;
        this.max = maxfield;
        this.direction = dir;
    }

    public WBar withTooltip(String label) {
        this.setRenderTooltip(true);
        this.tooltipLabel = label;
        return this;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void paintBackground(int x, int y) {
        int barSize;
        GuiDrawing.rect(this.bg, x, y, this.getWidth(), this.getHeight(), -1);
        float percent = (float)this.inventory.func_174887_a_(this.field) / (float)this.inventory.func_174887_a_(this.max);
        if (percent < 0.0f) {
            percent = 0.0f;
        }
        if (percent > 1.0f) {
            percent = 1.0f;
        }
        int barMax = this.getWidth();
        if (this.direction == Direction.DOWN || this.direction == Direction.UP) {
            barMax = this.getHeight();
        }
        if ((barSize = (int)((float)barMax * (percent = (float)((int)(percent * (float)barMax)) / (float)barMax))) <= 0) {
            return;
        }
        switch (this.direction) {
            case UP: {
                int left = x;
                int top = y + this.getHeight();
                GuiDrawing.rect(this.bar, left, top -= barSize, this.getWidth(), barSize, 0.0f, 1.0f - percent, 1.0f, 1.0f, -1);
                break;
            }
            case RIGHT: {
                GuiDrawing.rect(this.bar, x, y, barSize, this.getHeight(), 0.0f, 0.0f, percent, 1.0f, -1);
                break;
            }
            case DOWN: {
                GuiDrawing.rect(this.bar, x, y, this.getWidth(), barSize, 0.0f, 0.0f, 1.0f, percent, -1);
                break;
            }
            case LEFT: {
                int left = x + this.getWidth();
                int top = y;
                GuiDrawing.rect(this.bar, left -= barSize, top, barSize, this.getHeight(), 1.0f - percent, 0.0f, 1.0f, 1.0f, -1);
                break;
            }
        }
    }

    @Override
    public void addInformation(List<String> information) {
        int value = this.inventory.func_174887_a_(this.field);
        int valMax = this.inventory.func_174887_a_(this.max);
        information.add(String.format(this.tooltipLabel, value, valMax));
    }

    public static enum Direction {
        UP,
        RIGHT,
        DOWN,
        LEFT;

    }
}

