/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.utilpackets;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ConcreteToast;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.Message;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.NetworkContext;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.annotation.field.MarshalledAs;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.network.annotation.type.ReceivedOn;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ReceivedOn(value=Side.CLIENT)
public class DisplayToastMessage
extends Message {
    public String title;
    public String subtitle;
    @MarshalledAs(value="i64")
    public long timing;
    @MarshalledAs(value="i32")
    public int titleColor;
    @MarshalledAs(value="i32")
    public int subtitleColor;
    public String texture;
    @MarshalledAs(value="i32")
    public int textureX;
    @MarshalledAs(value="i32")
    public int textureY;

    public DisplayToastMessage(NetworkContext ctx) {
        super(ctx);
    }

    private DisplayToastMessage(NetworkContext ctx, @Nonnull String title, @Nullable String subtitle, long timing, @Nonnull String texture, int titleColor, int subtitleColor, int textureX, int textureY) {
        super(ctx);
        this.title = title;
        this.subtitle = subtitle;
        this.timing = timing;
        this.texture = texture;
        this.titleColor = titleColor;
        this.subtitleColor = subtitleColor;
        this.textureX = textureX;
        this.textureY = textureY;
    }

    public static Builder builder(String title) {
        return new Builder(title);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void handle(EntityPlayer player) {
        ConcreteToast toast = ConcreteToast.builder(this.title).setSubtitle(this.subtitle).setTiming(this.timing).setTexture(this.texture).setTitleColor(this.titleColor).setSubtitleColor(this.subtitleColor).setTextureX(this.textureX).setTextureY(this.textureY).create();
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)toast);
    }

    public static class Builder {
        private String title;
        private String subtitle;
        private long timing = 5000L;
        private String texture = "textures/gui/toasts.png";
        private int titleColor = -256;
        private int subtitleColor = -1;
        private int textureX = 0;
        private int textureY = 96;

        private Builder(String title) {
            this.title = title;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setTiming(long timing) {
            this.timing = timing;
            return this;
        }

        public Builder setTexture(String texture) {
            this.texture = texture;
            return this;
        }

        public Builder setTitleColor(int titleColor) {
            this.titleColor = titleColor;
            return this;
        }

        public Builder setSubtitleColor(int subtitleColor) {
            this.subtitleColor = subtitleColor;
            return this;
        }

        public Builder setTextureX(int textureX) {
            this.textureX = textureX;
            return this;
        }

        public Builder setTextureY(int textureY) {
            this.textureY = textureY;
            return this;
        }

        public DisplayToastMessage create(NetworkContext ctx) {
            return new DisplayToastMessage(ctx, this.title, this.subtitle, this.timing, this.texture, this.titleColor, this.subtitleColor, this.textureX, this.textureY);
        }
    }
}

