/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockContainerBase;
import de.ellpeck.actuallyadditions.mod.blocks.base.ItemBlockBase;
import de.ellpeck.actuallyadditions.mod.inventory.GuiHandler;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChest;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChestLarge;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityGiantChestMedium;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.ItemUtil;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGiantChest
extends BlockContainerBase {
    public final int type;

    public BlockGiantChest(String name, int type) {
        super(Material.field_151575_d, name);
        this.type = type;
        this.setHarvestLevel("axe", 0);
        this.func_149711_c(0.5f);
        this.func_149752_b(15.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public TileEntity func_149915_a(World world, int par2) {
        switch (this.type) {
            case 1: {
                return new TileEntityGiantChestMedium();
            }
            case 2: {
                return new TileEntityGiantChestLarge();
            }
        }
        return new TileEntityGiantChest();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing par6, float par7, float par8, float par9) {
        if (!world.field_72995_K) {
            TileEntityGiantChest chest = (TileEntityGiantChest)world.func_175625_s(pos);
            if (chest != null) {
                chest.fillWithLoot(player);
                player.openGui((Object)ActuallyAdditions.INSTANCE, GuiHandler.GuiTypes.GIANT_CHEST.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return true;
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77978_p() != null && (tile = world.func_175625_s(pos)) instanceof TileEntityGiantChest) {
            NBTTagList list = stack.func_77978_p().func_150295_c("Items", 10);
            ItemStackHandlerAA inv = ((TileEntityGiantChest)tile).inv;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound compound = list.func_150305_b(i);
                if (compound == null || !compound.func_74764_b("id")) continue;
                inv.setStackInSlot(i, new ItemStack(list.func_150305_b(i)));
            }
        }
        super.func_180633_a(world, pos, state, entity, stack);
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStackHandlerAA slots;
        int place;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityGiantChest && (place = ItemUtil.getPlaceAt((slots = ((TileEntityGiantChest)tile).inv).getItems(), new ItemStack(InitItems.itemCrateKeeper), false)) >= 0) {
            ItemStack stackInQuestion;
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < slots.getSlots(); ++i) {
                if (i == place) continue;
                NBTTagCompound compound = new NBTTagCompound();
                if (StackUtil.isValid(slots.getStackInSlot(i))) {
                    slots.getStackInSlot(i).func_77955_b(compound);
                }
                list.func_74742_a((NBTBase)compound);
            }
            if (list.func_74745_c() > 0 && StackUtil.isValid(stackInQuestion = (ItemStack)drops.get(0))) {
                if (stackInQuestion.func_77978_p() == null) {
                    stackInQuestion.func_77982_d(new NBTTagCompound());
                }
                stackInQuestion.func_77978_p().func_74782_a("Items", (NBTBase)list);
            }
        }
    }

    @Override
    public boolean shouldDropInventory(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return !(tile instanceof TileEntityGiantChest) || !ItemUtil.contains(((TileEntityGiantChest)tile).inv.getItems(), new ItemStack(InitItems.itemCrateKeeper), false);
    }

    @Override
    protected ItemBlockBase getItemBlock() {
        return new TheItemBlock((Block)this);
    }

    public static class TheItemBlock
    extends ItemBlockBase {
        public TheItemBlock(Block block) {
            super(block);
        }

        public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
            int type;
            int n = type = this.field_150939_a instanceof BlockGiantChest ? ((BlockGiantChest)this.field_150939_a).type : -1;
            if (type == 2) {
                tooltip.add(TextFormatting.ITALIC + StringUtil.localize("container.actuallyadditions.giantChestLarge.desc"));
            } else if (type == 0) {
                tooltip.add(TextFormatting.ITALIC + StringUtil.localize("container.actuallyadditions.giantChest.desc"));
            }
        }

        public NBTTagCompound getNBTShareTag(ItemStack stack) {
            return null;
        }
    }
}

