/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.recipe.ReColourRecipe;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.lib.colour.EnumColour;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Factories {

    public static class MultiIngredient
    extends CompoundIngredient {
        public MultiIngredient(Collection<Ingredient> children) {
            super(children);
        }
    }

    public static class WoolIngredientFactory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
            for (EnumColour c : EnumColour.values()) {
                ingredients.add((Ingredient)new OreIngredient(c.getWoolOreName()));
            }
            return new MultiIngredient(ingredients);
        }
    }

    public static class DyeIngredientFactory
    implements IIngredientFactory {
        @Nonnull
        public Ingredient parse(JsonContext context, JsonObject json) {
            return DyeIngredientFactory.create();
        }

        public static Ingredient create() {
            HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
            for (EnumColour c : EnumColour.values()) {
                ingredients.add((Ingredient)new OreIngredient(c.getDyeOreName()));
            }
            return new MultiIngredient(ingredients);
        }
    }

    public static class ReColourFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ItemStack result = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("result"), (JsonContext)context);
            Ingredient ingredient = json.has("ingredient") ? CraftingHelper.getIngredient((JsonElement)json.getAsJsonObject("ingredient"), (JsonContext)context) : Ingredient.func_193369_a((ItemStack[])new ItemStack[]{result});
            return new ReColourRecipe(result, ingredient, DyeIngredientFactory.create());
        }
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new CraftingRecipe(recipe.func_77571_b(), (NonNullList<Ingredient>)recipe.func_192400_c());
        }
    }

    public static class CraftingRecipe
    extends RecipeBase {
        public CraftingRecipe(@Nonnull ItemStack result, NonNullList<Ingredient> input) {
            super(new ResourceLocation("enderstorage", "crafting_recipe"), result, input);
        }

        @Override
        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            EnumColour colour = EnumColour.WHITE;
            block0: for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    EnumColour c;
                    ItemStack stack = inv.func_70463_b(x, y);
                    if (stack.func_190926_b() || (c = EnumColour.fromWoolStack((ItemStack)stack)) == null) continue;
                    colour = c;
                    break block0;
                }
            }
            Frequency frequency = new Frequency(colour, colour, colour);
            return frequency.writeToStack(super.func_77572_b(inv));
        }
    }
}

