/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api;

import buildcraft.api.IBuildCraftMod;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public enum BCModules implements IBuildCraftMod
{
    LIB,
    CORE,
    BUILDERS,
    ENERGY,
    FACTORY,
    ROBOTICS,
    SILICON,
    TRANSPORT,
    COMPAT;

    public static final BCModules[] VALUES;
    private static boolean hasChecked;
    private static BCModules[] loadedModules;
    private static BCModules[] missingModules;
    public final String lowerCaseName = this.name().toLowerCase(Locale.ROOT);
    public final String camelCaseName = this.name().charAt(0) + this.lowerCaseName.substring(1);
    private final String modId = "buildcraft" + this.lowerCaseName;
    private boolean loaded;

    private static void checkLoadStatus() {
        if (hasChecked) {
            return;
        }
        BCModules.load0();
    }

    private static synchronized void load0() {
        if (hasChecked) {
            return;
        }
        if (!Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION)) {
            throw new RuntimeException("You can only use BCModules.isLoaded from pre-init onwards!");
        }
        ArrayList<BCModules> found = new ArrayList<BCModules>();
        ArrayList<BCModules> missing = new ArrayList<BCModules>();
        for (BCModules module : VALUES) {
            module.loaded = Loader.isModLoaded((String)module.modId);
            if (module.loaded) {
                found.add(module);
                continue;
            }
            missing.add(module);
        }
        loadedModules = found.toArray(new BCModules[0]);
        missingModules = missing.toArray(new BCModules[0]);
        hasChecked = true;
    }

    @Nullable
    public static BCModules getBcMod(String testModId) {
        for (BCModules mod : VALUES) {
            if (!mod.modId.equals(testModId)) continue;
            return mod;
        }
        return null;
    }

    public static boolean isBcMod(String testModId) {
        return BCModules.getBcMod(testModId) != null;
    }

    public static BCModules[] getLoadedModules() {
        BCModules.checkLoadStatus();
        return loadedModules;
    }

    public static BCModules[] getMissingModules() {
        BCModules.checkLoadStatus();
        return missingModules;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    public boolean isLoaded() {
        BCModules.checkLoadStatus();
        return this.loaded;
    }

    public ResourceLocation createLocation(String path) {
        return new ResourceLocation(this.getModId(), path);
    }

    public ModelResourceLocation createModelLocation(String path, String variant) {
        return new ModelResourceLocation(this.getModId() + ":" + path + "#" + variant);
    }

    public ModelResourceLocation createModelLocation(String pathAndVariant) {
        return new ModelResourceLocation(this.getModId() + ":" + pathAndVariant);
    }

    static {
        VALUES = BCModules.values();
        hasChecked = false;
    }
}

