/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.schematics;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.SchematicBlockContext;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public interface ISchematicBlock {
    public void init(SchematicBlockContext var1);

    default public boolean isAir() {
        return false;
    }

    @Nonnull
    default public Set<BlockPos> getRequiredBlockOffsets() {
        return Collections.emptySet();
    }

    @Nonnull
    default public List<ItemStack> computeRequiredItems() {
        return Collections.emptyList();
    }

    @Nonnull
    default public List<FluidStack> computeRequiredFluids() {
        return Collections.emptyList();
    }

    public ISchematicBlock getRotated(Rotation var1);

    public boolean canBuild(World var1, BlockPos var2);

    default public boolean isReadyToBuild(World world, BlockPos blockPos) {
        return true;
    }

    public boolean build(World var1, BlockPos var2);

    public boolean buildWithoutChecks(World var1, BlockPos var2);

    public boolean isBuilt(World var1, BlockPos var2);

    public NBTTagCompound serializeNBT();

    public void deserializeNBT(NBTTagCompound var1) throws InvalidInputDataException;
}

