/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.gui.GuiStack;
import buildcraft.lib.misc.GuiUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.text.TextFormatting;

public final class PageLinkItemStack
extends PageLink {
    private static final boolean FULL_TOOLITP = true;
    public final ItemStack stack;
    public final List<String> tooltip;
    public final String searchText;

    public static PageLinkItemStack create(boolean startVisible, ItemStack stack, Profiler prof) {
        prof.func_76320_a("create_page_link");
        prof.func_76320_a("get_tooltip");
        List<String> tooltip = GuiUtil.getUnFormattedTooltip(stack);
        prof.func_76318_c("join_tooltip");
        String searchText = PageLinkItemStack.joinTooltip(tooltip);
        prof.func_76318_c("create_line");
        GuiStack icon = new GuiStack(stack);
        PageLine text = new PageLine(icon, icon, 2, tooltip.get(0), true);
        prof.func_76319_b();
        PageLinkItemStack page = new PageLinkItemStack(text, startVisible, stack, tooltip, searchText);
        prof.func_76319_b();
        return page;
    }

    private static String joinTooltip(List<String> tooltip) {
        StringBuilder joiner = new StringBuilder();
        PageLinkItemStack.joinTooltipLine(tooltip, joiner, 0);
        for (int i = 1; i < tooltip.size(); ++i) {
            joiner.append('\n');
            PageLinkItemStack.joinTooltipLine(tooltip, joiner, i);
        }
        return joiner.toString();
    }

    private static void joinTooltipLine(List<String> tooltip, StringBuilder joiner, int i) {
        String line = PageLinkItemStack.removeFormatting(tooltip.get(i));
        tooltip.set(i, line);
        joiner.append(line.toLowerCase(Locale.ROOT));
    }

    private static String removeFormatting(String s) {
        char[] to = new char[s.length()];
        int len = 0;
        for (int ci = 0; ci < s.length(); ++ci) {
            char c = s.charAt(ci);
            if (c == '\u00a7') {
                ++ci;
                continue;
            }
            to[len++] = c;
        }
        return new String(to, 0, len);
    }

    private PageLinkItemStack(PageLine text, boolean startVisible, ItemStack stack, List<String> tooltip, String searchText) {
        super(text, startVisible);
        this.stack = stack;
        this.tooltip = tooltip;
        this.searchText = searchText;
    }

    private PageLinkItemStack(boolean startVisible, ItemStack stack, Profiler prof) {
        super(PageLinkItemStack.createPageLine(stack, prof), startVisible);
        this.stack = stack;
        prof.func_76320_a("get_tooltip");
        this.tooltip = GuiUtil.getUnFormattedTooltip(stack);
        prof.func_76318_c("join_tooltip");
        StringBuilder joiner = new StringBuilder();
        for (String s : this.tooltip) {
            if ((s = TextFormatting.func_110646_a((String)s)) == null) continue;
            joiner.append(s.toLowerCase(Locale.ROOT));
            joiner.append('\n');
        }
        this.searchText = joiner.toString();
        prof.func_76319_b();
    }

    private static PageLine createPageLine(ItemStack stack, Profiler prof) {
        prof.func_76320_a("create_line");
        GuiStack icon = new GuiStack(stack);
        prof.func_76320_a("get_display_name");
        String title = stack.func_82833_r();
        prof.func_76319_b();
        if (title == null) {
            Item item = stack.func_77973_b();
            String info = item.getRegistryName() + " " + item.getClass() + " (" + stack.serializeNBT() + ")";
            BCLog.logger.warn("[lib.guide] Found null display name! " + info);
            title = "!!NULL stack.getDisplayName(): " + info;
        }
        PageLine line = new PageLine(icon, icon, 2, title, true);
        prof.func_76319_b();
        return line;
    }

    @Override
    public String getSearchName() {
        return this.searchText;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip.size() == 1 ? null : this.tooltip;
    }

    @Override
    public void appendTooltip(GuiGuide gui) {
        if (this.tooltip.size() > 1) {
            gui.tooltipStack = this.stack;
        }
    }

    @Override
    public GuidePageFactory getFactoryLink() {
        return GuideManager.INSTANCE.getPageFor(this.stack);
    }
}

