/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideCrafting;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.NonNullMatrix;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class GuideCraftingFactory
implements GuidePartFactory {
    private final NonNullMatrix<Ingredient> input;
    @Nonnull
    private final ItemStack output;
    private final int hash;

    public GuideCraftingFactory(Ingredient[][] input, ItemStack output) {
        this.input = new NonNullMatrix<Ingredient>(input, Ingredient.field_193370_a);
        this.output = StackUtil.asNonNull(output);
        NBTTagList hashNbt = new NBTTagList();
        for (Ingredient ingredient : this.input) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : ingredient.func_193365_a()) {
                list.func_74742_a((NBTBase)stack.serializeNBT());
            }
            hashNbt.func_74742_a((NBTBase)list);
        }
        this.hash = hashNbt.hashCode();
    }

    public static GuidePartFactory create(@Nonnull ItemStack stack) {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!OreDictionary.itemMatches((ItemStack)stack, (ItemStack)StackUtil.asNonNull(recipe.func_77571_b()), (boolean)false)) continue;
            GuidePartFactory val = GuideCraftingFactory.getFactory(recipe);
            if (val != null) {
                return val;
            }
            BCLog.logger.warn("[lib.guide.crafting] Found a matching recipe, but of an unknown " + recipe.getClass() + " for " + stack.func_82833_r());
        }
        return null;
    }

    public static GuidePartFactory getFactory(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        NonNullList input = recipe.func_192400_c();
        if (input == null || input.isEmpty() || output.func_190926_b()) {
            return null;
        }
        Ingredient[][] matrix = new Ingredient[3][3];
        int maxX = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : 3;
        int maxY = recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeHeight() : 3;
        int offsetX = maxX == 1 ? 1 : 0;
        int offsetY = maxY == 1 ? 1 : 0;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int i;
                matrix[x][y] = x < offsetX || y < offsetY ? Ingredient.field_193370_a : ((i = x - offsetX + (y - offsetY) * maxX) >= input.size() || x - offsetX >= maxX ? Ingredient.field_193370_a : (Ingredient)input.get(i));
            }
        }
        return new GuideCraftingFactory(matrix, output);
    }

    @Nonnull
    private static ItemStack oreConvert(Object object) {
        if (object == null) {
            return StackUtil.EMPTY;
        }
        if (object instanceof ItemStack) {
            return ((ItemStack)object).func_77946_l();
        }
        if (object instanceof String) {
            NonNullList stacks = OreDictionary.getOres((String)((String)object));
            object = stacks;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return StackUtil.EMPTY;
            }
            Object first = list.get(0);
            if (first == null) {
                return StackUtil.EMPTY;
            }
            if (first instanceof ItemStack) {
                ItemStack best = (ItemStack)first;
                for (Object obj : list) {
                    ItemStack stack;
                    if (!(obj instanceof ItemStack) || Item.func_150891_b((Item)(stack = (ItemStack)obj).func_77973_b()) >= Item.func_150891_b((Item)best.func_77973_b())) continue;
                    best = stack;
                }
                return best.func_77946_l();
            }
            BCLog.logger.warn("Found a list with unknown contents! " + first.getClass());
        }
        BCLog.logger.warn("Found an ore with an unknown " + object.getClass());
        return StackUtil.EMPTY;
    }

    public static GuidePartFactory create(Item output) {
        return GuideCraftingFactory.create(new ItemStack(output));
    }

    @Override
    public GuideCrafting createNew(GuiGuide gui) {
        return new GuideCrafting(gui, this.input, this.output);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GuideCraftingFactory other = (GuideCraftingFactory)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.input.getWidth() != other.input.getWidth() || this.input.getHeight() != other.input.getHeight()) {
            return false;
        }
        NBTTagList nbtThis = new NBTTagList();
        for (Ingredient ingredient : this.input) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : ingredient.func_193365_a()) {
                list.func_74742_a((NBTBase)stack.serializeNBT());
            }
            nbtThis.func_74742_a((NBTBase)list);
        }
        NBTTagList nbtThat = new NBTTagList();
        for (Ingredient ingredient : other.input) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : ingredient.func_193365_a()) {
                list.func_74742_a((NBTBase)stack.serializeNBT());
            }
            nbtThat.func_74742_a((NBTBase)list);
        }
        return nbtThis.equals((Object)nbtThat);
    }
}

