/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideSmelting;
import buildcraft.lib.misc.StackUtil;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class GuideSmeltingFactory
implements GuidePartFactory {
    @Nonnull
    private final ItemStack input;
    @Nonnull
    private final ItemStack output;
    private final int hash;

    public GuideSmeltingFactory(ItemStack input, ItemStack output) {
        this.input = StackUtil.asNonNull(input);
        this.output = StackUtil.asNonNull(output);
        this.hash = Arrays.hashCode(new int[]{input.serializeNBT().hashCode(), output.serializeNBT().hashCode()});
    }

    public static GuideSmeltingFactory create(ItemStack stack) {
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)((ItemStack)entry.getValue()))) continue;
            return new GuideSmeltingFactory((ItemStack)entry.getKey(), stack);
        }
        return null;
    }

    public static GuideSmeltingFactory create(Item output) {
        return GuideSmeltingFactory.create(new ItemStack(output));
    }

    @Override
    public GuideSmelting createNew(GuiGuide gui) {
        return new GuideSmelting(gui, this.input, this.output);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GuideSmeltingFactory other = (GuideSmeltingFactory)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return ItemStack.func_77989_b((ItemStack)this.input, (ItemStack)other.input) && ItemStack.func_77989_b((ItemStack)this.output, (ItemStack)other.output);
    }
}

