/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.sprite.SpriteRaw;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.GuiSpriteScaled;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.button.GuiButtonDrawable;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.button.IButtonClickEventListener;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.SpriteUtil;
import net.minecraft.util.ResourceLocation;

public class ElementTypeButton
extends ElementType {
    public static final String NAME = "buildcraftlib:button";
    public static final ElementTypeButton INSTANCE = new ElementTypeButton();

    private ElementTypeButton() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        IButtonClickEventListener listener;
        Boolean current;
        FunctionContext ctx = ElementTypeButton.createContext(json);
        ElementTypeButton.inheritProperty(json, "area[0]", "pos[0]");
        ElementTypeButton.inheritProperty(json, "area[1]", "pos[1]");
        ElementTypeButton.inheritProperty(json, "area[2]", "size[0]");
        ElementTypeButton.inheritProperty(json, "area[3]", "size[1]");
        ElementTypeButton.inheritProperty(json, "size[0]", "modes.enabled[2]");
        ElementTypeButton.inheritProperty(json, "size[1]", "modes.enabled[3]");
        ElementTypeButton.inheritProperty(json, "sprite", "modes.enabled.sprite");
        ElementTypeButton.inheritProperty(json, "texture", "modes.enabled.texture");
        ElementTypeButton.inheritProperty(json, "size[0]", "modes.disabled[2]");
        ElementTypeButton.inheritProperty(json, "size[1]", "modes.disabled[3]");
        ElementTypeButton.inheritProperty(json, "sprite", "modes.disabled.sprite");
        ElementTypeButton.inheritProperty(json, "texture", "modes.disabled.texture");
        ElementTypeButton.inheritProperty(json, "size[0]", "modes.active[2]");
        ElementTypeButton.inheritProperty(json, "size[1]", "modes.active[3]");
        ElementTypeButton.inheritProperty(json, "sprite", "modes.active.sprite");
        ElementTypeButton.inheritProperty(json, "texture", "modes.active.texture");
        ElementTypeButton.inheritProperty(json, "size[0]", "modes.hovered[2]");
        ElementTypeButton.inheritProperty(json, "size[1]", "modes.hovered[3]");
        ElementTypeButton.inheritProperty(json, "sprite", "modes.hovered.sprite");
        ElementTypeButton.inheritProperty(json, "texture", "modes.hovered.texture");
        ElementTypeButton.inheritProperty(json, "size[0]", "modes.active_hovered[2]");
        ElementTypeButton.inheritProperty(json, "size[1]", "modes.active_hovered[3]");
        ElementTypeButton.inheritProperty(json, "sprite", "modes.active_hovered.sprite");
        ElementTypeButton.inheritProperty(json, "texture", "modes.active_hovered.texture");
        int posX = ElementTypeButton.resolveEquationInt(json, "pos[0]", ctx);
        int posY = ElementTypeButton.resolveEquationInt(json, "pos[1]", ctx);
        int sizeX = ElementTypeButton.resolveEquationInt(json, "size[0]", ctx);
        int sizeY = ElementTypeButton.resolveEquationInt(json, "size[1]", ctx);
        String buttonId = json.properties.containsKey("button") ? json.properties.get("button") : ElementTypeButton.resolveEquation(json, "button_expression", ctx);
        ISimpleDrawable drEnabled = ElementTypeButton.resolveDrawable(ctx, info, json, gui, sizeX, sizeY, "modes.enabled");
        GuiRectangle rect = new GuiRectangle(posX, posY, sizeX, sizeY);
        GuiButtonDrawable.Builder buttonBuilder = new GuiButtonDrawable.Builder(rect, drEnabled);
        buttonBuilder.active = ElementTypeButton.resolveDrawable(ctx, info, json, gui, sizeX, sizeY, "modes.active");
        buttonBuilder.hovered = ElementTypeButton.resolveDrawable(ctx, info, json, gui, sizeX, sizeY, "modes.hovered");
        buttonBuilder.activeHovered = ElementTypeButton.resolveDrawable(ctx, info, json, gui, sizeX, sizeY, "modes.active_hovered");
        buttonBuilder.disabled = ElementTypeButton.resolveDrawable(ctx, info, json, gui, sizeX, sizeY, "modes.disabled");
        buttonBuilder.disabledActive = ElementTypeButton.resolveDrawable(ctx, info, json, gui, sizeX, sizeY, "modes.active_disabled");
        GuiButtonDrawable button = new GuiButtonDrawable(gui, json.name, parent, buttonBuilder);
        IButtonBehaviour behaviour = gui.properties.get(buttonId, IButtonBehaviour.class);
        if (behaviour != null) {
            button.setBehaviour(behaviour);
        }
        if ((current = gui.properties.get(buttonId, Boolean.class)) != null) {
            button.setActive(current);
        }
        if ((listener = gui.properties.get(buttonId, IButtonClickEventListener.class)) == null) {
            BCLog.logger.warn("[lib.gui.json] Unknown button id '" + buttonId + "'");
        } else {
            button.registerListener(listener);
        }
        return button;
    }

    private static ISimpleDrawable resolveDrawable(FunctionContext ctx, JsonGuiInfo guiInfo, JsonGuiElement json, BuildCraftJsonGui gui, int sizeX, int sizeY, String key) {
        double[] uvs = new double[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = ElementTypeButton.resolveEquationDouble(json, key + "[" + i + "]", ctx);
        }
        ElementType.SrcTexture texture = ElementTypeButton.resolveTexture(guiInfo, json, key);
        ISprite sprite = gui.properties.get(texture.origin, ISprite.class);
        if (sprite != null) {
            sprite = GuiUtil.subRelative(sprite, uvs[0], uvs[1], uvs[2], uvs[3], texture.texSize);
        } else {
            ResourceLocation loc = SpriteUtil.transformLocation(new ResourceLocation(texture.origin));
            sprite = new SpriteRaw(loc, uvs[0], uvs[1], uvs[2], uvs[3], texture.texSize);
        }
        return new GuiSpriteScaled(sprite, sizeX, sizeY);
    }
}

