/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.lib.inventory.InjectableWrapper;
import buildcraft.lib.inventory.InventoryWrapper;
import buildcraft.lib.inventory.ItemHandlerWrapper;
import buildcraft.lib.inventory.NoSpaceInjectable;
import buildcraft.lib.inventory.NoSpaceTransactor;
import buildcraft.lib.inventory.SidedInventoryWrapper;
import buildcraft.lib.inventory.TransactorEntityArrow;
import buildcraft.lib.inventory.TransactorEntityItem;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class ItemTransactorHelper {
    @Nonnull
    public static IItemTransactor getTransactor(ICapabilityProvider provider, EnumFacing face) {
        if (provider == null) {
            return NoSpaceTransactor.INSTANCE;
        }
        IItemTransactor trans = (IItemTransactor)provider.getCapability(CapUtil.CAP_ITEM_TRANSACTOR, face);
        if (trans != null) {
            return trans;
        }
        IItemHandler handler = (IItemHandler)provider.getCapability(CapUtil.CAP_ITEMS, face);
        if (handler == null) {
            if (provider instanceof ISidedInventory) {
                return new SidedInventoryWrapper((ISidedInventory)provider, face);
            }
            if (provider instanceof IInventory) {
                return new InventoryWrapper((IInventory)provider);
            }
            return NoSpaceTransactor.INSTANCE;
        }
        if (handler instanceof IItemTransactor) {
            return (IItemTransactor)handler;
        }
        return new ItemHandlerWrapper(handler);
    }

    @Nonnull
    public static IItemTransactor getTransactor(InventoryPlayer inventory) {
        if (inventory == null) {
            return NoSpaceTransactor.INSTANCE;
        }
        return new InventoryWrapper((IInventory)inventory);
    }

    @Nonnull
    public static IItemTransactor getTransactorForEntity(Entity entity, EnumFacing face) {
        IItemTransactor transactor = ItemTransactorHelper.getTransactor((ICapabilityProvider)entity, face);
        if (transactor != NoSpaceTransactor.INSTANCE) {
            return transactor;
        }
        if (entity instanceof EntityItem) {
            return new TransactorEntityItem((EntityItem)entity);
        }
        if (entity instanceof EntityArrow) {
            return new TransactorEntityArrow((EntityArrow)entity);
        }
        return NoSpaceTransactor.INSTANCE;
    }

    @Nonnull
    public static IInjectable getInjectable(ICapabilityProvider provider, EnumFacing face) {
        if (provider == null) {
            return NoSpaceInjectable.INSTANCE;
        }
        IInjectable injectable = (IInjectable)provider.getCapability(PipeApi.CAP_INJECTABLE, face);
        if (injectable == null) {
            return NoSpaceInjectable.INSTANCE;
        }
        return injectable;
    }

    public static IItemTransactor wrapInjectable(IInjectable injectable, EnumFacing facing) {
        return new InjectableWrapper(injectable, facing);
    }

    public static NonNullList<ItemStack> insertAllBypass(IItemTransactor transactor, NonNullList<ItemStack> stacks, boolean simulate) {
        NonNullList leftOver = NonNullList.func_191196_a();
        for (ItemStack stack : stacks) {
            ItemStack leftOverStack = transactor.insert(stack, false, simulate);
            if (leftOverStack.func_190926_b()) continue;
            leftOver.add((Object)leftOverStack);
        }
        return leftOver;
    }

    public static int move(IItemTransactor src, IItemTransactor dst) {
        return ItemTransactorHelper.move(src, dst, Integer.MAX_VALUE);
    }

    public static int move(IItemTransactor src, IItemTransactor dst, int maxItems) {
        return ItemTransactorHelper.move(src, dst, null, maxItems);
    }

    public static int move(IItemTransactor src, IItemTransactor dst, IStackFilter filter) {
        return ItemTransactorHelper.move(src, dst, filter, Integer.MAX_VALUE);
    }

    public static int move(IItemTransactor src, IItemTransactor dst, IStackFilter filter, int maxItems) {
        int m;
        int moved = 0;
        IStackFilter rFilter = dst::canPartiallyAccept;
        if (filter != null) {
            rFilter = rFilter.and(filter);
        }
        while ((m = ItemTransactorHelper.moveSingle0(src, dst, rFilter, maxItems - moved, false, false)) != 0) {
            moved += m;
        }
        return moved;
    }

    public static int moveSingle(IItemTransactor src, IItemTransactor dst, IStackFilter filter, boolean simulateSrc, boolean simulateDst) {
        return ItemTransactorHelper.moveSingle(src, dst, filter, Integer.MAX_VALUE, simulateSrc, simulateDst);
    }

    public static int moveSingle(IItemTransactor src, IItemTransactor dst, IStackFilter filter, int maxItems, boolean simulateSrc, boolean simulateDst) {
        IStackFilter rFilter = dst::canPartiallyAccept;
        if (filter != null) {
            rFilter = rFilter.and(filter);
        }
        return ItemTransactorHelper.moveSingle0(src, dst, rFilter, maxItems, simulateSrc, simulateDst);
    }

    private static int moveSingle0(IItemTransactor src, IItemTransactor dst, IStackFilter filter, int maxItems, boolean simulateSrc, boolean simulateDst) {
        ItemStack potential = src.extract(filter, 1, maxItems, true);
        if (potential.func_190926_b()) {
            return 0;
        }
        ItemStack leftOver = dst.insert(potential, false, simulateDst);
        IStackFilter exactFilter = stack -> StackUtil.canMerge(stack, potential);
        int toTake = potential.func_190916_E() - leftOver.func_190916_E();
        ItemStack taken = src.extract(exactFilter, toTake, toTake, simulateSrc);
        if (taken.func_190916_E() != toTake) {
            String msg = "One of the two transactors (either src = ";
            msg = msg + src.getClass() + " or dst = " + dst.getClass() + ")";
            msg = msg + " didn't respect the movement flags! ( potential = " + potential;
            msg = msg + ", leftOver = " + leftOver + ", taken = " + taken;
            msg = msg + ", count = " + toTake + " )";
            throw new IllegalStateException(msg);
        }
        return toTake;
    }

    public static IItemTransactor.IItemInsertable createDroppingTransactor(World world, Vec3d vec) {
        return (stack, allorNone, simulate) -> {
            if (!simulate) {
                InventoryUtil.drop(world, vec, stack);
            }
            return StackUtil.EMPTY;
        };
    }
}

