/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory.filter;

import buildcraft.api.core.IStackFilter;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class CraftingFilter
implements IStackFilter {
    private final NonNullList<ItemStack> stacks;

    public CraftingFilter(ItemStack ... stacks) {
        this.stacks = StackUtil.listOf(stacks);
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        if (this.stacks.size() == 0 || !this.hasFilter()) {
            return true;
        }
        for (ItemStack stack1 : this.stacks) {
            if (!StackUtil.isCraftingEquivalent(stack1, stack, true)) continue;
            return true;
        }
        return false;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    public boolean hasFilter() {
        for (ItemStack filter : this.stacks) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }
}

