/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.path.task;

import buildcraft.lib.path.task.AnalysedChunk;
import buildcraft.lib.path.task.EnumTraversalExpense;
import buildcraft.lib.path.task.FilledChunk;
import java.util.HashSet;
import java.util.concurrent.Callable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class TaskMiniChunkAnalyser
implements Callable<AnalysedChunk> {
    private final FilledChunk filled;

    public TaskMiniChunkAnalyser(FilledChunk filled) {
        this.filled = filled;
    }

    @Override
    public AnalysedChunk call() {
        AnalysedChunk chunk = new AnalysedChunk(this.filled);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    AnalysedChunk.MiniGraph g;
                    EnumTraversalExpense exp = chunk.expenses[x][y][z];
                    if (!(exp != EnumTraversalExpense.SOLID & (g = chunk.graphs[x][y][z]) == null)) continue;
                    TaskMiniChunkAnalyser.spreadGraph(chunk, x, y, z);
                }
            }
        }
        return chunk;
    }

    private static void spreadGraph(AnalysedChunk chunk, int x, int y, int z) {
        HashSet<BlockPos> openSet = new HashSet<BlockPos>();
        HashSet<BlockPos> closedSet = new HashSet<BlockPos>();
        AnalysedChunk.MiniGraph graph = new AnalysedChunk.MiniGraph();
        openSet.add(new BlockPos(x, y, z));
        while (!openSet.isEmpty()) {
            int z_;
            int y_;
            BlockPos toTest = (BlockPos)openSet.iterator().next();
            int x_ = toTest.func_177958_n();
            EnumTraversalExpense expense = chunk.expenses[x_][y_ = toTest.func_177956_o()][z_ = toTest.func_177952_p()];
            if (expense == EnumTraversalExpense.SOLID) continue;
            ++graph.blockCount;
            graph.totalExpense += expense.expense;
            chunk.graphs[x_][y_][z_] = graph;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                BlockPos offset = toTest.func_177972_a(face);
                if (!TaskMiniChunkAnalyser.isValid(offset) || closedSet.contains(offset)) continue;
                openSet.add(offset);
            }
            openSet.remove(toTest);
            closedSet.add(toTest);
        }
    }

    public static boolean isValid(BlockPos offset) {
        if (offset.func_177958_n() < 0 || offset.func_177958_n() >= 16) {
            return false;
        }
        if (offset.func_177956_o() < 0 || offset.func_177956_o() >= 16) {
            return false;
        }
        return offset.func_177952_p() >= 0 && offset.func_177952_p() < 16;
    }
}

