/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.item.ItemPipeHolder;
import com.google.common.collect.ImmutableSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="buildcrafttransport")
public class BCTransportRecipes {
    @GameRegistry.ObjectHolder(value="buildcraftsilicon:assembly_table")
    private static final Block SILICON_TABLE_ASSEMBLY = null;

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemWood, "plankWood");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemCobble, "cobblestone");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemStone, "stone");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemQuartz, "blockQuartz");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemIron, "ingotIron");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemGold, "ingotGold");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemClay, Blocks.field_150435_aG);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemSandstone, new ItemStack(Blocks.field_150322_A, 1, Short.MAX_VALUE));
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemVoid, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()), "dustRedstone");
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemObsidian, Blocks.field_150343_Z);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemDiamond, Items.field_151045_i);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemLapis, Blocks.field_150368_y);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemDaizuli, Blocks.field_150368_y, Items.field_151045_i);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemDiaWood, "plankWood", Items.field_151045_i);
        BCTransportRecipes.addPipeRecipe(BCTransportItems.pipeItemStripes, "gearGold");
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemDiaWood, BCTransportItems.pipeItemEmzuli, Blocks.field_150368_y);
        ItemBC_Neptune waterproof = BCTransportItems.waterproof;
        if (waterproof == null) {
            waterproof = Items.field_151123_aH;
        }
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemWood, BCTransportItems.pipeFluidWood, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemCobble, BCTransportItems.pipeFluidCobble, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemStone, BCTransportItems.pipeFluidStone, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemQuartz, BCTransportItems.pipeFluidQuartz, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemIron, BCTransportItems.pipeFluidIron, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemGold, BCTransportItems.pipeFluidGold, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemClay, BCTransportItems.pipeFluidClay, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemSandstone, BCTransportItems.pipeFluidSandstone, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemVoid, BCTransportItems.pipeFluidVoid, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemObsidian, BCTransportItems.pipeFluidObsidian, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemDiamond, BCTransportItems.pipeFluidDiamond, waterproof);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemDiaWood, BCTransportItems.pipeFluidDiaWood, waterproof);
        String upgrade = "dustRedstone";
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemWood, BCTransportItems.pipePowerWood, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemCobble, BCTransportItems.pipePowerCobble, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemStone, BCTransportItems.pipePowerStone, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemQuartz, BCTransportItems.pipePowerQuartz, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemGold, BCTransportItems.pipePowerGold, upgrade);
        BCTransportRecipes.addPipeUpgradeRecipe(BCTransportItems.pipeItemSandstone, BCTransportItems.pipePowerSandstone, upgrade);
        if (BCTransportItems.wire != null) {
            for (EnumDyeColor color : ColourUtil.COLOURS) {
                String name = String.format("wire-%s", color.func_176762_d());
                ImmutableSet input = ImmutableSet.of((Object)IngredientStack.of("dustRedstone"), (Object)IngredientStack.of(ColourUtil.getDyeName(color)));
                AssemblyRecipeRegistry.register(new AssemblyRecipeBasic(name, 10000L * MjAPI.MJ, (ImmutableSet<IngredientStack>)input, new ItemStack((Item)BCTransportItems.wire, 8, color.func_176765_a())));
            }
        }
    }

    private static void addPipeRecipe(ItemPipeHolder pipe, Object material) {
        BCTransportRecipes.addPipeRecipe(pipe, material, material);
    }

    private static void addPipeRecipe(ItemPipeHolder pipe, Object left, Object right) {
        if (pipe == null) {
            return;
        }
        ItemStack result = new ItemStack((Item)pipe, 8);
        ShapedOreRecipe recipe = new ShapedOreRecipe(pipe.getRegistryName(), result, new Object[]{"lgr", Character.valueOf('l'), left, Character.valueOf('r'), right, Character.valueOf('g'), "blockGlassColorless"});
        recipe.setRegistryName(new ResourceLocation(pipe.getRegistryName() + "_colorless"));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)recipe);
        for (EnumDyeColor colour : EnumDyeColor.values()) {
            ItemStack resultStack = new ItemStack((Item)pipe, 8, colour.func_176765_a() + 1);
            ShapedOreRecipe colorRecipe = new ShapedOreRecipe(pipe.getRegistryName(), resultStack, new Object[]{"lgr", Character.valueOf('l'), left, Character.valueOf('r'), right, Character.valueOf('g'), "blockGlass" + ColourUtil.getName(colour)});
            colorRecipe.setRegistryName(new ResourceLocation(pipe.getRegistryName() + "_" + colour));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)colorRecipe);
        }
    }

    private static void addPipeUpgradeRecipe(ItemPipeHolder from, ItemPipeHolder to, Object additional) {
        if (from == null || to == null) {
            return;
        }
        if (additional == null) {
            throw new NullPointerException("additional");
        }
        IRecipe returnRecipe = (IRecipe)new ShapelessOreRecipe(to.getRegistryName(), new ItemStack((Item)from), new Object[]{new ItemStack((Item)to)}).setRegistryName(new ResourceLocation(to.getRegistryName() + "_undo"));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)returnRecipe);
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193367_a((Item)from));
        list.add((Object)CraftingHelper.getIngredient((Object)additional));
        IRecipe upgradeRecipe = (IRecipe)new ShapelessRecipes(to.getRegistryName().func_110623_a(), new ItemStack((Item)to), list).setRegistryName(new ResourceLocation(to.getRegistryName() + "_colorless"));
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)upgradeRecipe);
        for (EnumDyeColor colour : ColourUtil.COLOURS) {
            ItemStack f = new ItemStack((Item)from, 1, colour.func_176765_a() + 1);
            ItemStack t = new ItemStack((Item)to, 1, colour.func_176765_a() + 1);
            IRecipe returnRecipeColored = (IRecipe)new ShapelessOreRecipe(to.getRegistryName(), f, new Object[]{t}).setRegistryName(new ResourceLocation(to.getRegistryName() + "_" + colour.func_176610_l() + "_undo"));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)returnRecipeColored);
            NonNullList colorList = NonNullList.func_191196_a();
            colorList.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{f}));
            colorList.add((Object)CraftingHelper.getIngredient((Object)additional));
            IRecipe upgradeRecipeColored = (IRecipe)new ShapelessOreRecipe(to.getRegistryName(), colorList, t).setRegistryName(new ResourceLocation(to.getRegistryName() + "_" + colour.func_176610_l()));
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)upgradeRecipeColored);
        }
    }
}

