/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IWireManager;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeExtensionManager;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.lib.misc.BlockUtil;
import buildcraft.lib.misc.CapUtil;
import buildcraft.lib.misc.InventoryUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.transport.pipe.behaviour.PipeBehaviourStripes;
import buildcraft.transport.wire.WireManager;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public enum PipeExtensionManager implements IPipeExtensionManager
{
    INSTANCE;

    private final Int2ObjectOpenHashMap<List<PipeExtensionRequest>> requests = new Int2ObjectOpenHashMap();
    private final Set<PipeDefinition> retractionPipeDefs = new HashSet<PipeDefinition>();

    @Override
    public boolean requestPipeExtension(World world, BlockPos pos, EnumFacing dir, IStripesActivator stripes, ItemStack stack) {
        if (world.field_72995_K || stack.func_190926_b() || !(stack.func_77973_b() instanceof IItemPipe)) {
            return false;
        }
        int id = world.field_73011_w.getDimension();
        ArrayList<PipeExtensionRequest> rList = (ArrayList<PipeExtensionRequest>)this.requests.get(id);
        if (rList == null) {
            rList = new ArrayList<PipeExtensionRequest>();
            this.requests.put(id, rList);
        }
        return rList.add(new PipeExtensionRequest(pos, dir, stripes, ((IItemPipe)stack.func_77973_b()).getDefinition(), stack.func_77946_l()));
    }

    @Override
    public void registerRetractionPipe(PipeDefinition pipeDefinition) {
        if (pipeDefinition != null) {
            this.retractionPipeDefs.add(pipeDefinition);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
            return;
        }
        List rList = (List)this.requests.get(event.world.field_73011_w.getDimension());
        if (rList == null) {
            return;
        }
        for (PipeExtensionRequest r : rList) {
            if (this.retractionPipeDefs.contains(r.pipeDef)) {
                this.retract(event.world, r);
                continue;
            }
            this.extend(event.world, r);
        }
        rList.clear();
    }

    private void retract(World w, PipeExtensionRequest r) {
        boolean canceled;
        EnumFacing retractDir = r.dir.func_176734_d();
        if (!this.isValidRetractionPath(w, r, retractDir)) {
            ArrayList<EnumFacing> possible = new ArrayList<EnumFacing>();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (facing.func_176740_k() == r.dir.func_176740_k() || !this.isValidRetractionPath(w, r, facing)) continue;
                possible.add(facing);
            }
            if (possible.isEmpty()) {
                r.stripes.sendItem(r.stack.func_77946_l(), r.dir);
                return;
            }
            retractDir = (EnumFacing)possible.get(MathHelper.func_76136_a((Random)w.field_73012_v, (int)0, (int)(possible.size() - 1)));
        }
        BlockPos p = r.pos.func_177972_a(retractDir);
        NonNullList stacksToSendBack = NonNullList.func_191196_a();
        stacksToSendBack.add((Object)r.stack);
        BlockSnapshot blockSnapshot1 = BlockSnapshot.getBlockSnapshot((World)w, (BlockPos)r.pos);
        IBlockState stripesStateOld = w.func_180495_p(r.pos);
        TileEntity stripesTileOld = w.func_175625_s(r.pos);
        IPipeHolder holder = CapUtil.getCapability((ICapabilityProvider)stripesTileOld, PipeApi.CAP_PIPE_HOLDER, null);
        if (stripesTileOld == null || holder == null) {
            BCLog.logger.warn("Found an invalid request at " + r.pos + " as " + stripesTileOld + " was not a pipe tile!");
            return;
        }
        GameProfile owner = holder.getOwner();
        PipeBehaviour behaviour = holder.getPipe().getBehaviour();
        if (behaviour instanceof PipeBehaviourStripes) {
            ((PipeBehaviourStripes)behaviour).direction = retractDir.func_176734_d();
        }
        NBTTagCompound stripesNBTOld = new NBTTagCompound();
        stripesTileOld.func_189515_b(stripesNBTOld);
        BlockSnapshot blockSnapshot2 = BlockSnapshot.getBlockSnapshot((World)w, (BlockPos)p);
        NonNullList list = NonNullList.func_191196_a();
        boolean bl = canceled = !BlockUtil.breakBlock((WorldServer)w, p, (NonNullList<ItemStack>)list, r.pos, owner);
        if (canceled) {
            blockSnapshot2.restore(true);
            TileEntity tile = w.func_175625_s(p);
            if (tile != null) {
                tile.onLoad();
            }
        }
        if (!canceled) {
            stripesNBTOld.func_74768_a("x", p.func_177958_n());
            stripesNBTOld.func_74768_a("y", p.func_177956_o());
            stripesNBTOld.func_74768_a("z", p.func_177952_p());
            FakePlayer player = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)w, owner, p);
            player.field_71071_by.func_174888_l();
            w.func_180501_a(p, stripesStateOld, 3);
            BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot2, (EnumFacing)r.dir, (EnumHand)EnumHand.MAIN_HAND);
            canceled = placeEvent.isCanceled();
            if (canceled) {
                blockSnapshot2.restore(true);
                TileEntity tile = w.func_175625_s(r.pos);
                if (tile != null) {
                    tile.onLoad();
                }
            } else {
                SoundUtil.playBlockBreak(w, p, blockSnapshot2.getReplacedBlock());
                boolean bl2 = canceled = !BlockUtil.breakBlock((WorldServer)w, r.pos, (NonNullList<ItemStack>)NonNullList.func_191196_a(), r.pos, owner);
                if (canceled) {
                    blockSnapshot1.restore(true);
                    TileEntity tile1 = w.func_175625_s(r.pos);
                    if (tile1 != null) {
                        tile1.onLoad();
                    }
                    blockSnapshot2.restore(true);
                    TileEntity tile2 = w.func_175625_s(p);
                    if (tile2 != null) {
                        tile2.onLoad();
                    }
                } else {
                    stacksToSendBack.addAll((Collection)list);
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70304_b(i);
                        if (stack.func_190926_b()) continue;
                        stacksToSendBack.add((Object)stack);
                    }
                }
            }
        }
        this.cleanup(w, r, p, (NonNullList<ItemStack>)stacksToSendBack, canceled, stripesNBTOld);
    }

    private void extend(World w, PipeExtensionRequest r) {
        FakePlayer player;
        boolean canceled;
        BlockPos p = r.pos.func_177972_a(r.dir);
        if (!w.func_175623_d(p) && !w.func_180495_p(p).func_177230_c().func_176200_f((IBlockAccess)w, p)) {
            r.stripes.sendItem(r.stack.func_77946_l(), r.dir);
            return;
        }
        NonNullList stacksToSendBack = NonNullList.func_191196_a();
        IBlockState stripesStateOld = w.func_180495_p(r.pos);
        NBTTagCompound stripesNBTOld = new NBTTagCompound();
        TileEntity stripesTileOld = w.func_175625_s(r.pos);
        IPipeHolder holder = CapUtil.getCapability((ICapabilityProvider)stripesTileOld, PipeApi.CAP_PIPE_HOLDER, null);
        if (stripesTileOld == null || holder == null) {
            BCLog.logger.warn("Found an invalid request at " + r.pos + " as " + stripesTileOld + " was not a pipe tile!");
            return;
        }
        GameProfile owner = holder.getOwner();
        stripesTileOld.func_189515_b(stripesNBTOld);
        BlockSnapshot blockSnapshot1 = BlockSnapshot.getBlockSnapshot((World)w, (BlockPos)r.pos);
        boolean bl = canceled = !BlockUtil.breakBlock((WorldServer)w, r.pos, (NonNullList<ItemStack>)NonNullList.func_191196_a(), r.pos, owner);
        if (canceled) {
            stacksToSendBack.add((Object)r.stack);
            blockSnapshot1.restore(true);
            TileEntity tile = w.func_175625_s(r.pos);
            if (tile != null) {
                tile.onLoad();
            }
        }
        NonNullList list = NonNullList.func_191196_a();
        if (!canceled) {
            player = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)w, owner, r.pos);
            player.field_71071_by.func_174888_l();
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, r.stack);
            EnumActionResult result = ForgeHooks.onPlaceItemIntoWorld((ItemStack)r.stack, (EntityPlayer)player, (World)w, (BlockPos)r.pos, (EnumFacing)r.dir.func_176734_d(), (float)0.5f, (float)0.5f, (float)0.5f, (EnumHand)EnumHand.MAIN_HAND);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70304_b(i);
                if (stack.func_190926_b()) continue;
                list.add((Object)stack);
            }
            canceled = result != EnumActionResult.SUCCESS;
            if (canceled) {
                blockSnapshot1.restore(true);
                TileEntity tile = w.func_175625_s(r.pos);
                if (tile != null) {
                    tile.onLoad();
                }
            }
        }
        if (!canceled) {
            stripesNBTOld.func_74768_a("x", p.func_177958_n());
            stripesNBTOld.func_74768_a("y", p.func_177956_o());
            stripesNBTOld.func_74768_a("z", p.func_177952_p());
            player = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)w, owner, p);
            player.field_71071_by.func_174888_l();
            BlockSnapshot blockSnapshot2 = BlockSnapshot.getBlockSnapshot((World)w, (BlockPos)p);
            w.func_180501_a(p, stripesStateOld, 3);
            BlockEvent.PlaceEvent placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot2, (EnumFacing)r.dir.func_176734_d(), (EnumHand)EnumHand.MAIN_HAND);
            canceled = placeEvent.isCanceled();
            if (canceled) {
                stacksToSendBack.add((Object)r.stack);
                blockSnapshot1.restore(true);
                TileEntity tile = w.func_175625_s(r.pos);
                if (tile != null) {
                    tile.onLoad();
                }
                blockSnapshot2.restore(true);
            } else {
                stacksToSendBack.addAll((Collection)list);
            }
        } else {
            stacksToSendBack.addAll((Collection)list);
        }
        this.cleanup(w, r, p, (NonNullList<ItemStack>)stacksToSendBack, canceled, stripesNBTOld);
    }

    private void cleanup(World w, PipeExtensionRequest r, BlockPos p, NonNullList<ItemStack> stacksToSendBack, boolean canceled, NBTTagCompound stripesNBTOld) {
        IPipeHolder stripesPipeHolderNew;
        TileEntity stripesTileNew = w.func_175625_s(canceled ? r.pos : p);
        if (stripesTileNew == null) {
            InventoryUtil.dropAll(w, p, stacksToSendBack);
            return;
        }
        if (!canceled) {
            stripesTileNew.func_145839_a(stripesNBTOld);
            stripesTileNew.onLoad();
        }
        if ((stripesPipeHolderNew = CapUtil.getCapability((ICapabilityProvider)stripesTileNew, PipeApi.CAP_PIPE_HOLDER, null)) != null) {
            PipeBehaviour behaviour;
            IWireManager wireManager;
            if (!canceled && (wireManager = stripesPipeHolderNew.getWireManager()) instanceof WireManager) {
                ((WireManager)wireManager).getWireSystems().rebuildWireSystemsAround(stripesPipeHolderNew);
            }
            if ((behaviour = stripesPipeHolderNew.getPipe().getBehaviour()) instanceof IStripesActivator) {
                IStripesActivator stripesNew = (IStripesActivator)((Object)behaviour);
                for (ItemStack s : stacksToSendBack) {
                    if (stripesNew.sendItem(s = s.func_77946_l(), r.dir)) continue;
                    stripesNew.dropItem(s, r.dir);
                }
            } else {
                InventoryUtil.dropAll(w, p, stacksToSendBack);
            }
        } else {
            InventoryUtil.dropAll(w, p, stacksToSendBack);
        }
    }

    private boolean isValidRetractionPath(World w, PipeExtensionRequest r, EnumFacing retractDir) {
        TileEntity tile = w.func_175625_s(r.pos.func_177972_a(retractDir));
        IPipe pipe = CapUtil.getCapability((ICapabilityProvider)tile, PipeApi.CAP_PIPE, null);
        if (pipe != null) {
            boolean connected = false;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (pipe.getConnectedType(facing) == IPipe.ConnectedType.TILE) {
                    return false;
                }
                if (facing == retractDir.func_176734_d() && pipe.getConnectedType(facing) != IPipe.ConnectedType.PIPE) {
                    return false;
                }
                if (facing != retractDir.func_176734_d() && connected && pipe.getConnectedType(facing) != null) {
                    return false;
                }
                if (facing == retractDir.func_176734_d() || connected || pipe.getConnectedType(facing) == null) continue;
                connected = true;
            }
            return true;
        }
        return false;
    }

    private class PipeExtensionRequest {
        public final BlockPos pos;
        public final EnumFacing dir;
        public final IStripesActivator stripes;
        public final PipeDefinition pipeDef;
        public final ItemStack stack;

        private PipeExtensionRequest(BlockPos pos, EnumFacing dir, IStripesActivator stripes, PipeDefinition pipeDef, ItemStack stack) {
            this.pos = pos;
            this.dir = dir;
            this.stripes = stripes;
            this.pipeDef = pipeDef;
            this.stack = stack;
        }
    }
}

