/*
 * Decompiled with CFR 0.152.
 */
package romelo333.rflux.blocks;

import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.gui.GenericGuiContainer;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import romelo333.rflux.RFLux;
import romelo333.rflux.blocks.BlockColor;
import romelo333.rflux.blocks.GuiLight;
import romelo333.rflux.blocks.LightTE;

public abstract class GenericLightBlock<T extends LightTE>
extends GenericBlock<T, EmptyContainer> {
    protected final boolean onOff;
    public static final PropertyEnum<BlockColor> COLOR = PropertyEnum.func_177709_a((String)"color", BlockColor.class);
    public static final AxisAlignedBB BLOCK_DOWN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.3f, 1.0);
    public static final AxisAlignedBB BLOCK_UP = new AxisAlignedBB(0.0, (double)0.7f, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.3f);
    public static final AxisAlignedBB BLOCK_SOUTH = new AxisAlignedBB(0.0, 0.0, (double)0.7f, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.3f, 1.0, 1.0);
    public static final AxisAlignedBB BLOCK_EAST = new AxisAlignedBB((double)0.7f, 0.0, 0.0, 1.0, 1.0, 1.0);

    public boolean needsRedstoneCheck() {
        return true;
    }

    public GenericLightBlock(String name, Class<? extends T> c, boolean onOff) {
        super((ModBase)RFLux.instance, Material.field_151573_f, c, EmptyContainer::new, name, false);
        this.onOff = onOff;
        if (!this.onOff) {
            this.func_149647_a(RFLux.setup.getTab());
        }
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(this.onOff ? 1.0f : 0.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)BlockColor.WHITE)));
    }

    public GenericLightBlock(String name, Class<? extends T> c, Function<Block, ItemBlock> itemBlockFunction, boolean onOff) {
        super((ModBase)RFLux.instance, Material.field_151573_f, c, EmptyContainer::new, itemBlockFunction, name, false);
        this.onOff = onOff;
        if (!this.onOff) {
            this.func_149647_a(RFLux.setup.getTab());
        }
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149715_a(this.onOff ? 1.0f : 0.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)BlockColor.WHITE)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return GenericLightBlock.this.getModelResourceLocation(stack);
            }
        });
    }

    private ModelResourceLocation getModelResourceLocation(ItemStack stack) {
        int col = 0;
        if (stack.func_77942_o()) {
            col = stack.func_77978_p().func_74762_e("color");
        }
        BlockColor color = BlockColor.values()[col];
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        Map variants = dispatcher.func_175023_a().func_178120_a().func_188181_b((Block)this);
        return (ModelResourceLocation)variants.get(this.func_176223_P().func_177226_a(COLOR, (Comparable)((Object)color)));
    }

    public abstract GenericLightBlock getLitBlock();

    public abstract GenericLightBlock getUnlitBlock();

    public static boolean isSameBlock(GenericLightBlock b1, GenericLightBlock b2) {
        return b1.getLitBlock() == b2.getLitBlock() || b1.getLitBlock() == b2.getUnlitBlock();
    }

    public static ItemStack makeColoredBlock(Block block, BlockColor color, int amount) {
        ItemStack i = new ItemStack(block, amount);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("color", color.ordinal());
        i.func_77982_d(nbt);
        return i;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        if (this.getRotationType() == BaseBlock.RotationType.NONE) {
            return super.func_185496_a(state, world, pos);
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() instanceof GenericLightBlock && (te = world.func_175625_s(pos)) instanceof LightTE) {
            EnumFacing side = this.getFrontDirection(blockState);
            switch (side) {
                case DOWN: {
                    return BLOCK_DOWN;
                }
                case UP: {
                    return BLOCK_UP;
                }
                case NORTH: {
                    return BLOCK_NORTH;
                }
                case SOUTH: {
                    return BLOCK_SOUTH;
                }
                case WEST: {
                    return BLOCK_WEST;
                }
                case EAST: {
                    return BLOCK_EAST;
                }
            }
        }
        return BLOCK_DOWN;
    }

    public int getGuiID() {
        return 1;
    }

    public BiFunction<T, EmptyContainer, GenericGuiContainer<? super T>> getGuiFactory() {
        return GuiLight::new;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        BlockColor color = BlockColor.WHITE;
        if (te instanceof LightTE) {
            color = ((LightTE)te).getColor();
        }
        return state.func_177226_a(COLOR, (Comparable)((Object)color));
    }

    protected BlockStateContainer func_180661_e() {
        switch (this.getRotationType()) {
            case HORIZROTATION: {
                return new BlockStateContainer((Block)this, new IProperty[]{FACING_HORIZ, COLOR});
            }
            case ROTATION: {
                return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR});
            }
            case NONE: {
                return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
            }
        }
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }
}

