/*
 * Decompiled with CFR 0.152.
 */
package romelo333.rflux.blocks;

import java.util.HashMap;
import java.util.Map;
import romelo333.rflux.ConfigSetup;

public enum LightMode {
    MODE_NORMAL(0, "Normal mode"),
    MODE_EXTENDED(2, "Extended mode"),
    MODE_SUPER(4, "Super mode");

    private final int range;
    private final String name;
    private static final Map<String, LightMode> LIGHT_MODE_MAP;

    private LightMode(int range, String name) {
        this.range = range;
        this.name = name;
    }

    public int getRfUsage() {
        switch (this) {
            case MODE_NORMAL: {
                return ConfigSetup.LIGHTBLOCK_RFPERTICK_L0;
            }
            case MODE_EXTENDED: {
                return ConfigSetup.LIGHTBLOCK_RFPERTICK_L1;
            }
            case MODE_SUPER: {
                return ConfigSetup.LIGHTBLOCK_RFPERTICK_L2;
            }
        }
        return 0;
    }

    public int getRange() {
        return this.range;
    }

    public String getName() {
        return this.name;
    }

    public static LightMode getModeByName(String name) {
        return LIGHT_MODE_MAP.get(name);
    }

    static {
        LIGHT_MODE_MAP = new HashMap<String, LightMode>();
        for (LightMode mode : LightMode.values()) {
            LIGHT_MODE_MAP.put(mode.getName(), mode);
        }
    }
}

