/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.tileentity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.inventory.TileInventoryState;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public abstract class InventoryTileEntityBase
extends CyclopsTileEntity
implements ISidedInventory {
    private static final Random RAND = new Random();
    protected boolean sendUpdateOnInventoryChanged = false;
    private int inventoryHash = 0;

    public InventoryTileEntityBase() {
        this.addCapabilityInternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, new InvWrapper((IInventory)this));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side, new SidedInvWrapper((ISidedInventory)this, side));
        }
        if (Capabilities.INVENTORY_STATE != null) {
            this.addInventoryStateCapability();
        }
    }

    protected void addInventoryStateCapability() {
        this.addCapabilityInternal(Capabilities.INVENTORY_STATE, new TileInventoryState(this));
    }

    public abstract INBTInventory getInventory();

    public int func_70302_i_() {
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        if (slotId >= this.func_70302_i_() || slotId < 0) {
            return ItemStack.field_190927_a;
        }
        return this.getInventory().func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        ItemStack itemStack = this.getInventory().func_70298_a(slotId, count);
        if (!itemStack.func_190926_b()) {
            this.onInventoryChanged();
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack removed = this.getInventory().func_70304_b(slotId);
        if (!removed.func_190926_b()) {
            this.onInventoryChanged();
        }
        return removed;
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.getInventory().func_70299_a(slotId, itemstack);
        this.onInventoryChanged();
    }

    protected void updateInventoryHash() {
        ++this.inventoryHash;
    }

    protected void onInventoryChanged() {
        if (this.isSendUpdateOnInventoryChanged()) {
            this.sendUpdate();
        }
        this.updateInventoryHash();
    }

    public String func_70005_c_() {
        return this.getInventory().func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.getInventory().func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.getInventory().func_145748_c_();
    }

    public int func_70297_j_() {
        return this.getInventory().func_70297_j_();
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && entityPlayer.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer playerIn) {
        this.getInventory().func_174889_b(playerIn);
    }

    public void func_174886_c(EntityPlayer playerIn) {
        this.getInventory().func_174886_c(playerIn);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getInventory().func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return this.getInventory().func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.getInventory().func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.getInventory().func_174890_g();
    }

    public void func_174888_l() {
        this.getInventory().func_174888_l();
        this.updateInventoryHash();
    }

    public void func_70296_d() {
        this.updateInventoryHash();
        super.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        INBTInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.readFromNBT(tag);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        INBTInventory inventory = this.getInventory();
        if (inventory != null) {
            inventory.writeToNBT(tag);
        }
        return tag;
    }

    protected boolean canAccess(int slot, EnumFacing side) {
        boolean canAccess = false;
        for (int slotAccess : this.func_180463_a(side)) {
            if (slotAccess != slot) continue;
            canAccess = true;
        }
        return canAccess;
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return this.canAccess(slot, side) && this.func_94041_b(slot, itemStack);
    }

    public boolean func_180461_b(int slot, ItemStack itemStack, EnumFacing side) {
        return this.canAccess(slot, side);
    }

    public boolean func_191420_l() {
        return this.getInventory().func_191420_l();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.getInventory().func_70300_a(player);
    }

    public boolean isSendUpdateOnInventoryChanged() {
        return this.sendUpdateOnInventoryChanged;
    }

    public void setSendUpdateOnInventoryChanged(boolean sendUpdateOnInventoryChanged) {
        this.sendUpdateOnInventoryChanged = sendUpdateOnInventoryChanged;
    }

    public int getInventoryHash() {
        return this.inventoryHash;
    }
}

