/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.biodomeGen.BasicTreesBiome;
import chanceCubes.rewards.biodomeGen.DesertBiome;
import chanceCubes.rewards.biodomeGen.EndBiome;
import chanceCubes.rewards.biodomeGen.IBioDomeBiome;
import chanceCubes.rewards.biodomeGen.NetherBiome;
import chanceCubes.rewards.biodomeGen.OceanBiome;
import chanceCubes.rewards.biodomeGen.SnowGlobeBiome;
import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BioDomeReward
extends BaseCustomReward {
    private IBioDomeBiome[] biomes = new IBioDomeBiome[]{new BasicTreesBiome(), new DesertBiome(), new EndBiome(), new OceanBiome(), new SnowGlobeBiome(), new NetherBiome()};
    public static final int delayShorten = 10;

    public BioDomeReward() {
        super("chancecubes:BioDome", 0);
    }

    @Override
    public void trigger(World world, BlockPos pos, EntityPlayer player, Map<String, Object> settings) {
        IBioDomeBiome spawnedBiome = this.biomes[RewardsUtil.rand.nextInt(this.biomes.length)];
        this.genDome(pos, world, spawnedBiome);
    }

    public void genDome(BlockPos pos, World world, IBioDomeBiome spawnedBiome) {
        this.genDomePart(0, -25, pos, world, spawnedBiome);
    }

    public void genDomePart(int yinc, int xinc, final BlockPos pos, final World world, final IBioDomeBiome spawnedBiome) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        for (int z = -25; z <= 25; ++z) {
            BlockPos loc = new BlockPos(xinc, yinc, z);
            float dist = (float)(Math.abs(loc.func_185332_f(0, 0, 0)) - 25.0);
            if (!(dist < 1.0f)) continue;
            if (dist >= 0.0f) {
                blocks.add(new OffsetBlock(xinc, yinc, z, Blocks.field_150359_w, false, delay / 10));
                ++delay;
            } else if (yinc == 0) {
                blocks.add(new OffsetBlock(xinc, yinc, z, spawnedBiome.getFloorBlock(), false, delay / 10));
                ++delay;
            }
            spawnedBiome.getRandomGenBlock(dist, RewardsUtil.rand, xinc, yinc, z, blocks, delay);
        }
        final int nextXinc = xinc + 1 > 25 ? -25 : xinc + 1;
        int Yinctemp = yinc;
        if (nextXinc == -25) {
            int n = Yinctemp = Yinctemp + 1 > 25 ? -1 : Yinctemp + 1;
        }
        if (Yinctemp == -1) {
            Scheduler.scheduleTask(new Task("Entity_Delays", delay){

                @Override
                public void callback() {
                    spawnedBiome.spawnEntities(pos, world);
                }
            });
            return;
        }
        final int nextYinc = Yinctemp;
        for (OffsetBlock b : blocks) {
            b.spawnInWorld(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        Task task = new Task("BioDome Reward", delay / 10){

            @Override
            public void callback() {
                BioDomeReward.this.genDomePart(nextYinc, nextXinc, pos, world, spawnedBiome);
            }
        };
        Scheduler.scheduleTask(task);
    }
}

