/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.giantRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.util.RewardsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class BlockInfectionReward
extends BaseCustomReward {
    private IBlockState[] whitelist = new IBlockState[]{Blocks.field_150343_Z.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150348_b.func_176223_P(), Blocks.field_150440_ba.func_176223_P(), Blocks.field_150342_X.func_176223_P(), Blocks.field_150435_aG.func_176223_P(), Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.func_176764_b((int)RewardsUtil.rand.nextInt(16))), Blocks.field_150336_V.func_176223_P(), Blocks.field_150321_G.func_176223_P(), Blocks.field_150424_aL.func_176223_P()};
    private BlockPos[] touchingPos = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(0, 0, 1), new BlockPos(0, 1, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, -1), new BlockPos(0, -1, 0)};

    public BlockInfectionReward() {
        super("chancecubes:World_Infection", 0);
    }

    @Override
    public void trigger(World world, BlockPos pos, EntityPlayer player, Map<String, Object> settings) {
        int delay = 0;
        int delayShorten = 20;
        BlockPos lastPos = pos;
        ArrayList<BlockPos> possibleBlocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> changedBlocks = new ArrayList<BlockPos>();
        changedBlocks.add(new BlockPos(0, 0, 0));
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        this.addSurroundingBlocks(world, pos, new BlockPos(0, 0, 0), changedBlocks, possibleBlocks);
        for (int i = 0; i < 5000; ++i) {
            BlockPos nextPos;
            if (possibleBlocks.size() > 0) {
                int index = RewardsUtil.rand.nextInt(possibleBlocks.size());
                nextPos = (BlockPos)possibleBlocks.get(index);
                possibleBlocks.remove(index);
            } else {
                nextPos = lastPos.func_177971_a((Vec3i)this.touchingPos[RewardsUtil.rand.nextInt(this.touchingPos.length)]);
            }
            changedBlocks.add(nextPos);
            this.addSurroundingBlocks(world, pos, nextPos, changedBlocks, possibleBlocks);
            IBlockState state = this.whitelist[RewardsUtil.rand.nextInt(this.whitelist.length)];
            blocks.add(new OffsetBlock(nextPos.func_177958_n(), nextPos.func_177956_o(), nextPos.func_177952_p(), state, false, delay / delayShorten));
            ++delay;
            lastPos = nextPos;
        }
        for (OffsetBlock b : blocks) {
            b.spawnInWorld(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    private void addSurroundingBlocks(World world, BlockPos worldCord, BlockPos offsetCord, List<BlockPos> changedBlocks, List<BlockPos> possibleBlocks) {
        for (BlockPos pos : this.touchingPos) {
            BlockPos checkPos = offsetCord.func_177971_a((Vec3i)pos);
            if (changedBlocks.contains(checkPos) || possibleBlocks.contains(checkPos) || world.func_180495_p(worldCord.func_177971_a((Vec3i)checkPos)).func_177230_c() instanceof BlockAir) continue;
            possibleBlocks.add(checkPos);
        }
    }
}

