/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.tileentities;

import chanceCubes.config.CCubesSettings;
import chanceCubes.registry.ChanceCubeRegistry;
import chanceCubes.sounds.CCubesSounds;
import java.util.Random;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.model.TRSRTransformation;

public class TileChanceD20
extends TileEntity
implements ITickable {
    private static final Random random = new Random();
    private boolean breaking = false;
    private int stage = 0;
    public float rotation = 0.0f;
    public float rotationDelta = 0.0f;
    public float rotationInc = 0.0f;
    public float wave = 0.0f;
    private EntityPlayer player;
    private int chance;
    private boolean isScanned = false;
    public TRSRTransformation transform = TRSRTransformation.identity();

    public TileChanceD20() {
        if (!CCubesSettings.d20UseNormalChances) {
            this.chance = random.nextBoolean() ? -100 : 100;
        } else {
            this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            while (this.chance > 100 || this.chance < -100) {
                this.chance = Math.round((float)(random.nextGaussian() * 40.0));
            }
        }
    }

    public TileChanceD20(int initialChance) {
        this.chance = initialChance;
    }

    public void setChance(int newChance) {
        this.chance = newChance;
    }

    public int getChance() {
        return this.chance;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("chance", this.getChance());
        nbt = super.func_189515_b(nbt);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chance = nbt.func_74762_e("chance");
    }

    public void func_73660_a() {
        if (this.breaking) {
            ++this.stage;
        }
        if (this.stage > 200) {
            this.breaking = false;
            if (!this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175698_g(this.field_174879_c);
                this.field_145850_b.func_175713_t(this.field_174879_c);
                ChanceCubeRegistry.INSTANCE.triggerRandomReward(this.field_145850_b, this.field_174879_c, this.player, this.getChance());
            }
        } else if (this.field_145850_b.field_72995_K) {
            AxisAngle4d yaw = new AxisAngle4d(0.0, 1.0, 0.0, Math.toRadians((float)Minecraft.func_71386_F() % 10000.0f / 10000.0f * 360.0f) + (0.4 + Math.pow(1.02, this.getStage() + 1)));
            AxisAngle4d pitch = new AxisAngle4d(1.0, 0.0, 0.0, 0.0);
            Vector3f offset = new Vector3f(0.5f, 0.5f + this.wave * 0.15f, 0.5f);
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            matrix.setTranslation(offset);
            if (this.breaking) {
                Quat4f rot = new Quat4f(0.0f, 0.0f, 0.0f, 1.0f);
                Quat4f yawQuat = new Quat4f();
                Quat4f pitchQuat = new Quat4f();
                yawQuat.set(yaw);
                rot.mul(yawQuat);
                pitchQuat.set(pitch);
                rot.mul(pitchQuat);
                matrix.setRotation(rot);
            }
            this.transform = new TRSRTransformation(matrix);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    public void startBreaking(EntityPlayer player) {
        if (!this.breaking) {
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), CCubesSounds.D20_BREAK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.player = player;
            }
            this.breaking = true;
            this.stage = 0;
        }
    }

    public int getStage() {
        return this.stage;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData = this.func_189515_b(syncData);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, syncData);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean isScanned() {
        return this.isScanned;
    }

    public void setScanned(boolean isScanned) {
        this.isScanned = isScanned;
    }
}

