/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.client;

import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.config.RTConfig;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="randomtweaks")
public final class DingHandler {
    private static final Class<?> GENERAL_MOD_OPTIONS;
    private static final Class<?> BACKGROUND_MUTE;
    private static final Random random;
    private static final Minecraft mc;
    private static boolean playWorld;
    private static ISound sound;

    public static void onGameStarted() {
        if (!RandomTweaks.DING_LOADED && RTConfig.Ding.startupSounds.length != 0 && DingHandler.isDsurroundStartupSoundDisabled()) {
            DingHandler.playSound(RTConfig.Ding.startupSounds, RTConfig.Ding.startupSoundPitch, RTConfig.Ding.startupSoundVolume);
        }
    }

    @SubscribeEvent
    public static void onConnectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!RandomTweaks.DING_LOADED && RTConfig.Ding.worldLoadSounds.length != 0) {
            playWorld = true;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (!playWorld || event.phase != TickEvent.Phase.END || DingHandler.mc.field_71439_g == null) {
            return;
        }
        if (DingHandler.mc.field_71439_g.field_70173_aa >= 20 || mc.func_147113_T()) {
            DingHandler.playSound(RTConfig.Ding.worldLoadSounds, RTConfig.Ding.worldLoadSoundPitch, RTConfig.Ding.worldLoadSoundVolume);
            playWorld = false;
        }
    }

    public static void onClientTick() {
        if (sound == null) {
            return;
        }
        SoundHandler soundHandler = mc.func_147118_V();
        if (!soundHandler.func_147692_c(sound)) {
            MinecraftForge.EVENT_BUS.register(BACKGROUND_MUTE);
        }
    }

    public static void playSound(SoundEvent[] soundEvents, double pitch, double volume) {
        SoundEvent soundEvent = soundEvents[random.nextInt(soundEvents.length)];
        SoundHandler soundHandler = mc.func_147118_V();
        PositionedSoundRecord sound = PositionedSoundRecord.func_194007_a((SoundEvent)soundEvent, (float)((float)pitch), (float)((float)volume));
        if (!RTConfig.Ding.ignoreDsurroundMuteWhenBackground || BACKGROUND_MUTE == null) {
            soundHandler.func_147682_a((ISound)sound);
            return;
        }
        soundHandler.field_147694_f.field_148620_e.setMasterVolume(DingHandler.mc.field_71474_y.func_186711_a(SoundCategory.MASTER));
        soundHandler.func_147682_a((ISound)sound);
        DingHandler.sound = sound;
        MinecraftForge.EVENT_BUS.unregister(BACKGROUND_MUTE);
    }

    public static boolean isDsurroundStartupSoundDisabled() {
        if (GENERAL_MOD_OPTIONS == null) {
            return true;
        }
        try {
            Field startupSoundListField = GENERAL_MOD_OPTIONS.getDeclaredField("startupSoundList");
            String[] startupSoundList = (String[])startupSoundListField.get(null);
            return startupSoundList.length == 0;
        }
        catch (Exception ex) {
            RandomTweaks.LOGGER.error("Failed to check if Dynamic Surrounding's startup sound list is empty", (Throwable)ex);
            return true;
        }
    }

    public static Class<?> getDsurroundClass(String name) {
        try {
            return Class.forName("org.orecruncher.dsurround." + name);
        }
        catch (ClassNotFoundException ex) {
            try {
                return Class.forName("org.blockartistry.DynSurround." + name);
            }
            catch (ClassNotFoundException ex2) {
                RandomTweaks.LOGGER.error("Failed to find Dynamic Surroundings class: " + name, (Throwable)ex2);
                return null;
            }
        }
    }

    static {
        random = new Random();
        mc = Minecraft.func_71410_x();
        if (RandomTweaks.DYNAMIC_SURROUNDINGS_LOADED) {
            GENERAL_MOD_OPTIONS = DingHandler.getDsurroundClass("ModOptions$general");
            BACKGROUND_MUTE = DingHandler.getDsurroundClass("client.sound.BackgroundMute");
        } else {
            GENERAL_MOD_OPTIONS = null;
            BACKGROUND_MUTE = null;
        }
    }
}

