/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.client.ArmorEquipSoundHandler;
import com.therandomlabs.randomtweaks.common.ColoredSheepHandler;
import com.therandomlabs.randomtweaks.common.RTFoodStats;
import com.therandomlabs.randomtweaks.common.ZombieAIHandler;
import com.therandomlabs.randomtweaks.config.RTConfig;
import com.therandomlabs.randomtweaks.repackage.com.therandomlabs.randomlib.EntityUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class MiscEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer) {
            MiscEventHandler.onPlayerJoinWorld((EntityPlayer)entity);
            return;
        }
        if (entity instanceof EntityZombie) {
            ZombieAIHandler.onZombieJoinWorld((EntityZombie)entity);
        }
    }

    public static void onPlayerJoinWorld(EntityPlayer player) {
        IAttributeInstance attackSpeed = player.func_110148_a(SharedMonsterAttributes.field_188790_f);
        attackSpeed.func_111128_a(RTConfig.Misc.attackSpeed);
        if (RTConfig.Hunger.enabled && !RandomTweaks.APPLECORE_LOADED) {
            player.field_71100_bB = new RTFoodStats(player.field_71100_bB);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityAgeable)) {
            return;
        }
        if (RTConfig.SheepColorWeights.enabled && !RandomTweaks.COLORFUL_SHEEP_LOADED && entity.getClass() == EntitySheep.class) {
            ColoredSheepHandler.onSheepSpawn((EntitySheep)entity);
        }
        if (RTConfig.RandomizedAges.chance != 0.0) {
            EntityAgeable ageable = (EntityAgeable)entity;
            if (ageable.func_70631_g_()) {
                return;
            }
            EntityEntry entry = EntityRegistry.getEntry(ageable.getClass());
            if (ArrayUtils.contains((Object[])RTConfig.RandomizedAges.blacklist, (Object)entry)) {
                return;
            }
            Random rng = ageable.func_70681_au();
            if (rng.nextDouble() < RTConfig.RandomizedAges.chance) {
                int min = RTConfig.RandomizedAges.minimumAge;
                int max = RTConfig.RandomizedAges.maximumAge;
                if (min == max) {
                    ageable.func_70873_a(min);
                } else {
                    ageable.func_70873_a(rng.nextInt(max + 1 - min) + min);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_130014_f_().field_72995_K) {
            return;
        }
        if (RTConfig.Misc.entityNaNHealthFix && !RandomTweaks.ENTITY_NAN_HEALTH_FIX_LOADED && Float.isNaN(entity.func_110143_aJ())) {
            entity.func_70606_j(0.0f);
            return;
        }
        if (entity.getClass() == EntitySheep.class) {
            ColoredSheepHandler.onSheepTick((EntitySheep)entity);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        String gameRule;
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        if (RTConfig.Misc.entityNaNHealthFix && !RandomTweaks.ENTITY_NAN_HEALTH_FIX_LOADED && Float.isNaN(amount)) {
            RandomTweaks.LOGGER.error("{} was damaged by a NaN value.", (Object)entity);
            RandomTweaks.LOGGER.error("Immediate source: " + source);
            RandomTweaks.LOGGER.error("True source: " + source.func_76346_g());
            RandomTweaks.LOGGER.error("This damage will be canceled. Please report this to the relevant mod author.");
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            return;
        }
        if (source == DamageSource.field_76369_e) {
            gameRule = RTConfig.GameRules.drowningDamageMultiplier;
        } else if (source == DamageSource.field_76379_h) {
            gameRule = RTConfig.GameRules.fallDamageMultiplier;
        } else if (source == DamageSource.field_76372_a || source == DamageSource.field_76370_b) {
            gameRule = RTConfig.GameRules.fireDamageMultiplier;
        } else {
            return;
        }
        if (gameRule.isEmpty()) {
            return;
        }
        float multiplier = 0.0f;
        try {
            multiplier = Float.parseFloat(entity.func_130014_f_().func_82736_K().func_82767_a(gameRule));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (multiplier == 0.0f) {
            event.setCanceled(true);
        } else if (multiplier <= 0.0f) {
            event.setCanceled(true);
            entity.func_70606_j(Math.max(entity.func_110143_aJ() + amount * multiplier, entity.func_110138_aP()));
        } else {
            event.setAmount(amount * multiplier);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        IEntityOwnable otherPet;
        Entity attacker = event.getSource().func_76346_g();
        EntityLivingBase entity = event.getEntityLiving();
        if (attacker == null || !(entity instanceof IEntityOwnable)) {
            return;
        }
        IEntityOwnable pet = (IEntityOwnable)entity;
        UUID owner = pet.func_184753_b();
        if (owner == null) {
            return;
        }
        boolean protectFromSneaking = RTConfig.Animals.protectPetsFromSneakingOwners;
        if (RTConfig.Animals.protectPetsFromOwners && owner.equals(attacker.func_110124_au()) && (protectFromSneaking || !protectFromSneaking && !attacker.func_70093_af())) {
            event.setCanceled(true);
            return;
        }
        if (RTConfig.Animals.protectPetsFromOtherPets && attacker instanceof IEntityOwnable && owner.equals((otherPet = (IEntityOwnable)attacker).func_184753_b())) {
            entity.func_70604_c(null);
            ((EntityLivingBase)attacker).func_70604_c(null);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (RTConfig.Misc.mobsDropAllArmorAndEquipment && entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            Arrays.fill(living.field_82174_bp, 1.0f);
            Arrays.fill(living.field_184655_bs, 1.0f);
        }
        if (!RTConfig.Misc.mobsAlwaysDropLoot) {
            return;
        }
        World world = entity.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (entity.field_70718_bc == 0) {
            entity.field_70718_bc = 100;
        }
        if (entity.field_70717_bb == null) {
            entity.field_70717_bb = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDrops(LivingDropsEvent event) {
        if (RandomTweaks.VANILLATWEAKS_LOADED) {
            return;
        }
        Entity entity = event.getEntity();
        if (!entity.func_130014_f_().func_82736_K().func_82766_b("doMobLoot")) {
            return;
        }
        if (RTConfig.Animals.batLeatherDropChance != 0.0 && entity instanceof EntityBat && Math.random() < RTConfig.Animals.batLeatherDropChance) {
            entity.func_145779_a(Items.field_151116_aA, 1);
        }
        if (!RTConfig.Misc.entitiesDropNameTags) {
            return;
        }
        String customName = entity.func_95999_t();
        if (customName.isEmpty()) {
            return;
        }
        ItemStack nameTag = new ItemStack(Items.field_151057_cb);
        nameTag.func_151001_c(customName);
        entity.func_70099_a(nameTag, 0.0f);
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        if (RandomTweaks.RANDOMCONFIGS_LOADED || !RTConfig.Misc.disableAttacksDuringAttackCooldown) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_130014_f_().field_72995_K && player.func_184825_o(0.5f) != 1.0f) {
            player.func_184821_cY();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!RTConfig.Misc.updateAllMapsInInventory) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (i == player.field_71071_by.field_70461_c) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != Items.field_151098_aY) continue;
            Items.field_151098_aY.func_77872_a(world, (Entity)player, Items.field_151098_aY.func_77873_a(stack, world));
        }
    }

    @SubscribeEvent
    public static void onArrowNock(ArrowNockEvent event) {
        if (!RTConfig.Misc.bowInfinityFix) {
            return;
        }
        ItemStack bow = event.getBow();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0) {
            event.getEntityPlayer().func_184598_c(event.getHand());
            event.setAction(new ActionResult(EnumActionResult.SUCCESS, (Object)bow));
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!RTConfig.Misc.cakeSoundsAndParticles || RandomTweaks.CAKE_CHOMPS_LOADED) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockCake) || !player.func_71043_e(false)) {
            return;
        }
        Random random = player.func_70681_au();
        ItemStack stack = block.getPickBlock(state, null, world, pos, player);
        int id = Item.func_150891_b((Item)stack.func_77973_b());
        int meta = stack.func_77960_j();
        for (int i = 0; i < 5; ++i) {
            Vec3d particlePos = new Vec3d(((double)random.nextFloat() - 0.5) * 0.3, (double)(-random.nextFloat()) * 0.6 - 0.3, 0.6).func_178789_a(-player.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-player.field_70177_z * ((float)Math.PI / 180)).func_72441_c(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e() + 0.05, player.field_70161_v);
            Vec3d particleSpeed = new Vec3d(((double)random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-player.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-player.field_70177_z * ((float)Math.PI / 180));
            world.func_175688_a(EnumParticleTypes.ITEM_CRACK, particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, particleSpeed.field_72450_a, particleSpeed.field_72448_b, particleSpeed.field_72449_c, new int[]{id, meta});
        }
        player.func_184185_a(SoundEvents.field_187537_bA, 0.5f + 0.5f * (float)random.nextInt(2), (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.PlaceEvent event) {
        if (!RTConfig.Misc.wetSpongesDryInNether) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = event.getPlacedBlock();
        if (state.func_177230_c() != Blocks.field_150360_v || !((Boolean)state.func_177229_b((IProperty)BlockSponge.field_176313_a)).booleanValue()) {
            return;
        }
        BlockPos pos = event.getPos();
        if (!BiomeDictionary.getTypes((Biome)world.func_180494_b(pos)).contains(BiomeDictionary.Type.NETHER)) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(false)));
        world.func_184133_a(null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (!RTConfig.Misc.armorStandSwapping) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_130014_f_().field_72995_K || !player.func_70093_af() || player.func_175149_v()) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof EntityArmorStand)) {
            return;
        }
        event.setCanceled(true);
        EntityArmorStand armorStand = (EntityArmorStand)target;
        List armorStandInventory = (List)armorStand.func_184193_aE();
        for (EntityEquipmentSlot slot : EntityUtils.ARMOR_SLOTS) {
            ItemStack playerStack = player.func_184582_a(slot);
            ItemStack armorStandStack = armorStand.func_184582_a(slot);
            int index = slot.func_188454_b();
            player.field_71071_by.field_70460_b.set(index, (Object)armorStandStack);
            armorStandInventory.set(index, playerStack);
            SoundEvent playerEquipSound = ArmorEquipSoundHandler.getSound(armorStandStack);
            SoundEvent armorStandEquipSound = ArmorEquipSoundHandler.getSound(playerStack);
            if (playerEquipSound != null) {
                player.func_184185_a(playerEquipSound, 1.0f, 1.0f);
            }
            if (armorStandEquipSound == null) continue;
            armorStand.func_184185_a(armorStandEquipSound, 1.0f, 1.0f);
        }
    }
}

