/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common;

import com.therandomlabs.randomtweaks.config.RTConfig;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class TorchHandler {
    private static EnumFacing[] TORCH_ORIENTATIONS = BlockTorch.field_176596_a.func_177700_c().toArray(new EnumFacing[0]);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!RTConfig.Misc.torchReorientationBehavior.test(event.getPlayer())) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        block0: for (EnumFacing neighboringSide : TORCH_ORIENTATIONS) {
            BlockPos torchPos = pos.func_177972_a(neighboringSide);
            IBlockState torchState = world.func_180495_p(torchPos);
            Block block = torchState.func_177230_c();
            if (!(block instanceof BlockTorch) || TorchHandler.canPlaceAt(world, pos, torchPos, (EnumFacing)torchState.func_177229_b((IProperty)BlockTorch.field_176596_a))) continue;
            for (EnumFacing orientation : RTConfig.Misc.torchOrientations) {
                if (!TorchHandler.canPlaceAt(world, pos, torchPos, orientation)) continue;
                world.func_175656_a(torchPos, torchState.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)orientation));
                continue block0;
            }
        }
    }

    public static boolean canPlaceAt(World world, BlockPos brokenPos, BlockPos torchPos, EnumFacing orientation) {
        BlockPos attachPos = torchPos.func_177972_a(orientation.func_176734_d());
        if (brokenPos.equals((Object)attachPos)) {
            return false;
        }
        IBlockState attachState = world.func_180495_p(attachPos);
        Block attachBlock = attachState.func_177230_c();
        BlockFaceShape attachBlockShape = attachState.func_193401_d((IBlockAccess)world, attachPos, orientation);
        if (orientation == EnumFacing.UP) {
            return attachBlock.canPlaceTorchOnTop(attachState, (IBlockAccess)world, torchPos);
        }
        return !Block.func_193382_c((Block)attachBlock) && attachBlockShape == BlockFaceShape.SOLID;
    }

    public static enum Orientation {
        NORTH(EnumFacing.NORTH),
        SOUTH(EnumFacing.SOUTH),
        EAST(EnumFacing.EAST),
        WEST(EnumFacing.WEST),
        UP(EnumFacing.UP);

        private final EnumFacing facing;

        private Orientation(EnumFacing facing) {
            this.facing = facing;
        }

        public EnumFacing get() {
            return this.facing;
        }
    }

    public static enum Behavior {
        NEVER("never", player -> false),
        SNEAKING("sneaking", Entity::func_70093_af),
        NOT_SNEAKING("notSneaking", player -> !player.func_70093_af()),
        ALWAYS("always", player -> true);

        private final String translationKey;
        private final Predicate<EntityPlayer> predicate;

        private Behavior(String translationKey, Predicate<EntityPlayer> predicate) {
            this.translationKey = translationKey;
            this.predicate = predicate;
        }

        public String toString() {
            return "randomtweaks.config.misc.torchReorientationBehavior." + this.translationKey;
        }

        public boolean test(EntityPlayer player) {
            return this.predicate.test(player);
        }
    }
}

