/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common.world;

import com.google.common.base.Predicate;
import com.therandomlabs.randomtweaks.config.RTConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGeneratorOceanFloor
implements IWorldGenerator {
    private static final BlockMatcher GRAVEL = BlockMatcher.func_177642_a((Block)Blocks.field_150351_n);
    private static final WorldGenMinable CLAY = new WorldGenMinable(Blocks.field_150435_aG.func_176223_P(), RTConfig.OceanFloor.clayVeinSize, (Predicate)GRAVEL);
    private static final WorldGenMinable SAND = new WorldGenMinable(Blocks.field_150354_m.func_176223_P(), RTConfig.OceanFloor.sandVeinSize, (Predicate)GRAVEL);
    private static final WorldGenMinable DIRT = new WorldGenMinable(Blocks.field_150346_d.func_176223_P(), RTConfig.OceanFloor.dirtVeinSize, (Predicate)GRAVEL);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator generator, IChunkProvider provider) {
        if (world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.generate((WorldGenerator)CLAY, RTConfig.OceanFloor.clayChance, random, chunkX, chunkZ, world);
            this.generate((WorldGenerator)SAND, RTConfig.OceanFloor.sandChance, random, chunkX, chunkZ, world);
            this.generate((WorldGenerator)DIRT, RTConfig.OceanFloor.dirtChance, random, chunkX, chunkZ, world);
        }
    }

    private void generate(WorldGenerator generator, int chance, Random random, int chunkX, int chunkZ, World world) {
        int yDifference = RTConfig.OceanFloor.maxY - RTConfig.OceanFloor.minY;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        for (int i = 0; i < chance; ++i) {
            BlockPos pos = new BlockPos(x + random.nextInt(16), RTConfig.OceanFloor.minY + random.nextInt(yDifference), z + random.nextInt(16));
            Biome biome = world.func_180494_b(pos);
            if (!biome.getRegistryName().func_110623_a().contains("ocean")) continue;
            generator.func_180709_b(world, random, pos);
        }
    }

    static {
        if (RTConfig.OceanFloor.minY > RTConfig.OceanFloor.maxY) {
            throw new IllegalArgumentException("oceanFloor.minY must be lesser than or equal to oceanFloor.maxY");
        }
    }
}

