/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.stone.BlockTypes_StoneDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityAlloySmelter
extends TileEntityMultiblockPart<TileEntityAlloySmelter>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IProcessTile {
    NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public int process = 0;
    public int processMax = 0;
    public boolean active = false;
    public int burnTime = 0;
    public int lastBurnTime = 0;
    private static final int[] size = new int[]{2, 2, 2};

    public TileEntityAlloySmelter() {
        super(size);
    }

    @Override
    public IEProperties.PropertyBoolInverted getBoolProperty(Class<? extends IEBlockInterfaces.IUsesBooleanProperty> inf) {
        return inf == IEBlockInterfaces.IActiveState.class ? IEProperties.BOOLEANS[0] : null;
    }

    @Override
    public boolean getIsActive() {
        return this.active;
    }

    @Override
    public boolean canOpenGui() {
        return this.formed;
    }

    @Override
    public int getGuiID() {
        return 1;
    }

    @Override
    public TileEntity getGuiMaster() {
        return this.master();
    }

    @Override
    public float[] getBlockBounds() {
        return null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        return new ItemStack(IEContent.blockStoneDecoration, 1, BlockTypes_StoneDecoration.ALLOYBRICK.getMeta());
    }

    @Override
    public boolean isDummy() {
        return this.offset[0] != 0 || this.offset[1] != 0 || this.offset[2] != 0;
    }

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (!this.field_145850_b.field_72995_K && this.formed && !this.isDummy()) {
            ItemStack fuel;
            boolean a = this.active;
            if (this.burnTime > 0) {
                AlloyRecipe recipe;
                boolean doneWork = false;
                if (this.process > 0) {
                    if (((ItemStack)this.inventory.get(0)).func_190926_b() || ((ItemStack)this.inventory.get(1)).func_190926_b()) {
                        this.process = 0;
                        this.processMax = 0;
                    } else {
                        recipe = this.getRecipe();
                        if (recipe != null && recipe.time != this.processMax) {
                            this.processMax = 0;
                            this.process = 0;
                            this.active = false;
                        } else {
                            --this.process;
                            doneWork = true;
                            if (!this.active) {
                                this.active = true;
                            }
                        }
                    }
                    this.markContainingBlockForUpdate(null);
                }
                if (--this.burnTime % 10 == 0) {
                    this.markContainingBlockForUpdate(null);
                }
                if (this.process <= 0) {
                    if (this.processMax > 0) {
                        recipe = this.getRecipe();
                        if (recipe != null) {
                            boolean flip = !recipe.input0.matchesItemStack((ItemStack)this.inventory.get(0));
                            Utils.modifyInvStackSize(this.inventory, flip ? 1 : 0, -recipe.input0.inputSize);
                            Utils.modifyInvStackSize(this.inventory, flip ? 0 : 1, -recipe.input1.inputSize);
                            if (!((ItemStack)this.inventory.get(3)).func_190926_b()) {
                                ((ItemStack)this.inventory.get(3)).func_190917_f(recipe.output.func_77946_l().func_190916_E());
                            } else {
                                this.inventory.set(3, (Object)recipe.output.func_77946_l());
                            }
                        }
                        this.processMax = 0;
                    }
                    if ((recipe = this.getRecipe()) != null) {
                        this.process = recipe.time;
                        if (!doneWork) {
                            --this.process;
                        }
                        this.processMax = recipe.time;
                        this.active = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
            }
            if (this.burnTime <= 10 && this.getRecipe() != null && (this.process > 10 || this.processMax == 0) && TileEntityFurnace.func_145954_b((ItemStack)(fuel = (ItemStack)this.inventory.get(2)))) {
                this.lastBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                this.burnTime += this.lastBurnTime;
                Item itemFuel = fuel.func_77973_b();
                fuel.func_190918_g(1);
                if (fuel.func_190926_b()) {
                    this.inventory.set(2, (Object)itemFuel.getContainerItem(fuel));
                }
                this.markContainingBlockForUpdate(null);
            }
            if (a != this.active) {
                this.func_70296_d();
                for (int yy = -1; yy <= 1; ++yy) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        for (int zz = -1; zz <= 1; ++zz) {
                            TileEntity tileEntity = Utils.getExistingTileEntity(this.field_145850_b, this.func_174877_v().func_177982_a(xx, yy, zz));
                            if (tileEntity != null) {
                                tileEntity.func_70296_d();
                            }
                            this.markBlockForUpdate(this.func_174877_v().func_177982_a(xx, yy, zz), null);
                            this.field_145850_b.func_175641_c(this.func_174877_v().func_177982_a(xx, yy, zz), IEContent.blockStoneDevice, 1, this.active ? 1 : 0);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public AlloyRecipe getRecipe() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b() || ((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return null;
        }
        AlloyRecipe recipe = AlloyRecipe.findRecipe((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
        if (recipe == null) {
            return null;
        }
        if (((ItemStack)this.inventory.get(3)).func_190926_b() || OreDictionary.itemMatches((ItemStack)((ItemStack)this.inventory.get(3)), (ItemStack)recipe.output, (boolean)true) && ((ItemStack)this.inventory.get(3)).func_190916_E() + recipe.output.func_190916_E() <= this.getSlotLimit(3)) {
            return recipe;
        }
        return null;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        TileEntityAlloySmelter master = (TileEntityAlloySmelter)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        TileEntityAlloySmelter master = (TileEntityAlloySmelter)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean func_145842_c(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        } else if (id == 1) {
            this.active = arg == 1;
        }
        this.func_70296_d();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.process = nbt.func_74762_e("process");
        this.processMax = nbt.func_74762_e("processMax");
        this.active = nbt.func_74767_n("active");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.lastBurnTime = nbt.func_74762_e("lastBurnTime");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.func_150295_c("inventory", 10), 4);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("process", this.process);
        nbt.func_74768_a("processMax", this.processMax);
        nbt.func_74757_a("active", this.active);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("lastBurnTime", this.lastBurnTime);
        if (!descPacket) {
            nbt.func_74782_a("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return slot == 0 || slot == 1 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return false;
    }

    @Override
    public BlockPos getOrigin() {
        return this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]).func_177967_a(this.facing, -1).func_177972_a(this.facing.func_176735_f());
    }
}

