/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.DimensionManager;

public class TileEntityCoresample
extends TileEntityIEBase
implements IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText {
    public ItemStack coresample = ItemStack.field_190927_a;
    public EnumFacing facing = EnumFacing.NORTH;
    private String[] overlay = null;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.coresample = new ItemStack(nbt.func_74775_l("coresample"));
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74782_a("coresample", (NBTBase)this.coresample.func_77955_b(new NBTTagCompound()));
        nbt.func_74768_a("facing", this.facing.ordinal());
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return true;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return true;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!this.func_145831_w().field_72995_K) {
                EntityItem entityitem = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, this.getTileDrop(player, this.func_145831_w().func_180495_p(this.func_174877_v())));
                entityitem.func_174869_p();
                this.func_145831_w().func_175698_g(this.func_174877_v());
                this.func_145831_w().func_72838_d((Entity)entityitem);
            }
            return true;
        }
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151098_aY && ItemNBTHelper.hasKey(this.coresample, "coords")) {
            MapData mapData;
            if (!this.func_145831_w().field_72995_K && (mapData = ((ItemMap)heldItem.func_77973_b()).func_77873_a(heldItem, player.func_130014_f_())) != null) {
                int[] coords = ItemNBTHelper.getIntArray(this.coresample, "coords");
                String ident = "ie:coresample_" + coords[0] + ";" + coords[1] + ";" + coords[2];
                NBTTagCompound mapTagCompound = ItemNBTHelper.getTag(heldItem);
                NBTTagList nbttaglist = mapTagCompound.func_150295_c("Decorations", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    NBTTagCompound tagCompound = (NBTTagCompound)nbttaglist.func_179238_g(i);
                    if (!ident.equalsIgnoreCase(tagCompound.func_74779_i("id"))) continue;
                    nbttaglist.func_74744_a(i);
                    mapTagCompound.func_74782_a("Decorations", (NBTBase)nbttaglist);
                    mapData.field_76203_h.remove(ident);
                    return true;
                }
                double sampleX = (double)(coords[1] * 16) + 8.5;
                double sampleZ = (double)(coords[2] * 16) + 8.5;
                int mapScale = 1 << mapData.field_76197_d;
                float distX = (float)(sampleX - (double)mapData.field_76201_a) / (float)mapScale;
                float distZ = (float)(sampleZ - (double)mapData.field_76199_b) / (float)mapScale;
                if (distX >= -63.0f && distX <= 63.0f && distZ >= -63.0f && distZ <= 63.0f) {
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74778_a("id", ident);
                    tagCompound.func_74774_a("type", MapDecoration.Type.TARGET_POINT.func_191163_a());
                    tagCompound.func_74780_a("x", sampleX);
                    tagCompound.func_74780_a("z", sampleZ);
                    tagCompound.func_74780_a("rot", 180.0);
                    nbttaglist.func_74742_a((NBTBase)tagCompound);
                    mapTagCompound.func_74782_a("Decorations", (NBTBase)nbttaglist);
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.info.coresample.mapFail", new Object[0]));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.coresample.func_82837_s() ? new TextComponentString(this.coresample.func_82833_r()) : new TextComponentTranslation("item.immersiveengineering.coresample.name", new Object[0]);
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        return this.coresample;
    }

    @Override
    public void readOnPlacement(EntityLivingBase placer, ItemStack stack) {
        this.coresample = stack.func_77946_l();
    }

    @Override
    public boolean preventInventoryDrop() {
        return true;
    }

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (this.coresample != null && ItemNBTHelper.hasKey(this.coresample, "coords")) {
            if (this.overlay == null) {
                this.overlay = new String[3];
                int[] coords = ItemNBTHelper.getIntArray(this.coresample, "coords");
                this.overlay[0] = I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.noMineral", (Object[])new Object[0]);
                if (ItemNBTHelper.hasKey(this.coresample, "mineral")) {
                    String mineral = ItemNBTHelper.getString(this.coresample, "mineral");
                    String unloc = "desc.immersiveengineering.info.mineral." + mineral;
                    String loc = I18n.func_135052_a((String)unloc, (Object[])new Object[0]);
                    this.overlay[0] = TextFormatting.GOLD + I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.mineral", (Object[])new Object[]{unloc.equals(loc) ? mineral : loc});
                }
                WorldServer world = DimensionManager.getWorld((int)coords[0]);
                String s0 = coords[1] * 16 + ", " + coords[2] * 16;
                String s1 = coords[1] * 16 + 16 + ", " + (coords[2] * 16 + 16);
                if (world != null && world.field_73011_w != null) {
                    String name = world.field_73011_w.func_186058_p().func_186065_b();
                    if (name.toLowerCase(Locale.ENGLISH).startsWith("the ")) {
                        name = name.substring(4);
                    }
                    this.overlay[1] = name;
                } else {
                    this.overlay[1] = "Dimension " + coords[0];
                }
                this.overlay[2] = I18n.func_135052_a((String)"chat.immersiveengineering.info.coresample.pos", (Object[])new Object[]{s0, s1});
            }
            return this.overlay;
        }
        return new String[0];
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }
}

